package body List_Generic is

    pragma Suppress (Elaboration_Check);

    function Nil return List is
    begin
	return null;
    end Nil;

    function Is_Empty (L : List) return Boolean is
    begin
	return L = Nil;
    end Is_Empty;

    function First (L : List) return Element is
    begin
	return L.First;
    end First;

    function Rest (L : List) return List is
    begin
	return L.Rest;
    end Rest;

    function Make (X : Element; L : List) return List is
    begin
	return new Listdata'(X, L);
    end Make;

    procedure Set_Rest (L : List; To_Be : List) is
    begin
	L.Rest := To_Be;
    end Set_Rest;

    procedure Set_First (L : List; To_Be : Element) is
    begin
	L.First := To_Be;
    end Set_First;

    procedure Free (L : in out List) is
    begin
	L := null;
    end Free;

    function Length (L : List) return Natural is
	Count : Natural := 0;
	Iter : Iterator;
    begin
	Init (Iter, L);
	while not Done (Iter) loop
	    Count := Count + 1;
	    Next (Iter);
	end loop;
	return Count;
    end Length;


    procedure Init (Iter : out Iterator; L : List) is
    begin
	Iter := Iterator (L);
    end Init;

    procedure Next (Iter : in out Iterator) is
    begin
	Iter := Iterator (Iter.Rest);
    end Next;

    function Value (Iter : Iterator) return Element is
    begin
	return Iter.First;
    end Value;

    function Done (Iter : Iterator) return Boolean is
    begin
	return Iter = null;
    end Done;

end List_Generic;
