generic
    type Element is private;

    pragma Must_Be_Constrained (Yes => Element);

package Queue_Generic is

    type Queue is private;

    procedure Initialize (Q : out Queue);

    function Is_Empty (Q : Queue) return Boolean;
    procedure Make_Empty (Q : in out Queue);

    procedure Copy (Target : in out Queue; Source : Queue);

    procedure Add (Q : in out Queue; X : Element);
    procedure Delete (Q : in out Queue);
    function First (Q : Queue) return Element;
    -- on calls to delete and first, not is_empty(q) is assumed
    -- constraint error will be raises is is_empty(q)

    type Iterator is limited private;

    procedure Init (Iter : out Iterator; Q : Queue);
    procedure Next (Iter : in out Iterator);
    function Value (Iter : Iterator) return Element;
    function Done (Iter : Iterator) return Boolean;

    ------------------------------------------------------
    -- Implementation Notes and Non-Standard Operations --
    ------------------------------------------------------

    -- variables of type queue are initially empty
    --    therefore, the call to initialize is optional

    -- := and = are meaningless
    --   := implies sharing (introduces an alias) for sub-structures

    -- garbage may be generated

    --/inline    pragma inline(initialize);
    --/inline    pragma inline(is_empty);
    --/inline    pragma inline(make_empty);
    --/inline    pragma inline(add);

    --/inline    pragma inline(init);
    --/inline    pragma inline(next);
    --/inline    pragma inline(value);
    --/inline    pragma inline(done);
private

    type Node;
    type Pointer is access Node;

    type Node is
	record
	    Value : Element;
	    Link : Pointer;
	end record;

    type Queue is
	record
	    Head : Pointer;
	    Tail : Pointer;
	end record;

    type Iterator is new Queue;

end Queue_Generic;
