package body Queue_Generic is

    pragma Suppress (Elaboration_Check);

    procedure Initialize (Q : out Queue) is
    begin
	null;
    end Initialize;

    function Is_Empty (Q : Queue) return Boolean is
    begin
	return Q.Head = null;
    end Is_Empty;

    procedure Make_Empty (Q : in out Queue) is
    begin
	Q.Head := null;
	Q.Tail := null;
    end Make_Empty;

    procedure Init (Iter : out Iterator; Q : Queue) is
    begin
	Iter := Iterator (Q);
    end Init;

    procedure Next (Iter : in out Iterator) is
    begin
	Iter.Head := Iter.Head.Link;
    end Next;

    function Value (Iter : Iterator) return Element is
    begin
	return Iter.Head.Value;
    end Value;

    function Done (Iter : Iterator) return Boolean is
    begin
	return Iter.Head = null;
    end Done;

    procedure Copy (Target : in out Queue; Source : Queue) is
	Iter : Iterator;
    begin
	Make_Empty (Target);
	Init (Iter, Source);
	while not Done (Iter) loop
	    Add (Target, Value (Iter));
	    Next (Iter);
	end loop;
    end Copy;

    procedure Add (Q : in out Queue; X : Element) is
	New_Node : constant Pointer := new Node'(X, null);
    begin
	if Q.Head = null then
	    Q.Head := New_Node;
	else
	    Q.Tail.Link := New_Node;
	end if;
	Q.Tail := New_Node;
    end Add;

    procedure Delete (Q : in out Queue) is
	First : constant Pointer := Q.Head;
    begin
	Q.Head := First.Link;
	First.Link := null;
	if Q.Head = null then
	    Q.Tail := null;
	end if;
    end Delete;

    function First (Q : Queue) return Element is
    begin
	return Q.Head.Value;
    end First;

end Queue_Generic;
