generic
    type Element is private;
    -- must be a pure value
    -- ie. no initialization or finalization is necessary
    -- = and := are equality and copy

    pragma Must_Be_Constrained (Yes => Element);

package Set_Generic is

    type Set is private;

    procedure Initialize (S : out Set);

    function Is_Empty (S : Set) return Boolean;
    procedure Make_Empty (S : in out Set);

    procedure Copy (Target : in out Set; Source : Set);

    function Is_Member (S : Set; X : Element) return Boolean;

    procedure Add (S : in out Set; X : Element);
    procedure Delete (S : in out Set; X : Element);
    -- X is (is not) in S then the operation add (delete) is a no op.

    type Iterator is limited private;

    procedure Init (Iter : out Iterator; S : Set);
    procedure Next (Iter : in out Iterator);
    function Value (Iter : Iterator) return Element;
    function Done (Iter : Iterator) return Boolean;

    ------------------------------------------------------
    -- Implementation Notes and Non-Standard Operations --
    ------------------------------------------------------

    -- variables of type set are initially empty
    --    therefore, the call to initialize is optional
    --   initialize does make the set empty

    -- := and = operate on references
    --   := implies sharing (introduces an alias)
    --   = means is the same set, not the same value of type set

    -- garbage may be generated

    -- Concurrency Properties
    -- any number of read operations (is_empty,is_member) can procede
    -- concurrently with one write operations (add/delete/make_empty)

private

    type Node is
	record
	    Value : Element;
	    Link : Set;
	end record;

    type Set is access Node;

    type Iterator is new Set;

end Set_Generic;
