package body Set_Generic is

    pragma Suppress (Elaboration_Check);

    procedure Initialize (S : out Set) is
    begin
	S := null;
    end Initialize;

    function Is_Empty (S : Set) return Boolean is
    begin
	return S = null;
    end Is_Empty;

    procedure Make_Empty (S : in out Set) is
    begin
	S := null;
    end Make_Empty;

    procedure Init (Iter : out Iterator; S : Set) is
    begin
	Iter := Iterator (S);
    end Init;

    procedure Next (Iter : in out Iterator) is
    begin
	Iter := Iterator (Iter.Link);
    end Next;
    --/inline pragma Inline(Next);

    function Value (Iter : Iterator) return Element is
    begin
	return Iter.Value;
    end Value;
    --/inline pragma Inline(Value);

    function Done (Iter : Iterator) return Boolean is
    begin
	return Iter = null;
    end Done;

    procedure Copy (Target : in out Set; Source : Set) is
	Rest : Set := Source;
    begin
	Target := null;
	while Rest /= null loop
	    Target := new Node'(Rest.Value, Target);
	    Rest := Rest.Link;
	end loop;
    end Copy;


    function Is_Member (S : Set; X : Element) return Boolean is
	Rest : Set := S;
    begin
	while Rest /= null loop
	    if Rest.Value = X then
		return True;
	    end if;
	    Rest := Rest.Link;
	end loop;
	return False;
    end Is_Member;

    procedure Add (S : in out Set; X : Element) is
    begin
	if not Is_Member (S, X) then
	    S := new Node'(X, S);
	end if;
    end Add;

    procedure Delete (S : in out Set; X : Element) is
	Current : Set := S;
	Previous : Set := null;
    begin
	while Current /= null loop
	    if Current.Value = X then
		if Previous /= null then
		    Previous.Link := Current.Link;
		else
		    S := Current.Link;
		end if;
		return;
	    end if;
	    Previous := Current;
	    Current := Current.Link;
	end loop;
    end Delete;

end Set_Generic;
