package Sort_Utilities is

    generic
	type Element is private;       -- has ":="
	type Index is (<>);
	type Element_Array is array (Index range <>) of Element;
	with function "<" (Left, Right : Element) return Boolean;

    procedure Array_Shell_Sort 
		 (The_Table : in out Element_Array; Last_Element : Index);

    -- Rearranges the table, in place, such that
    --      The_Table (I) "<" The_Table (I + 1),
    -- for suitable I; uses "Shell sort". 
    --
    -- CAUTIONS:
    --
    --     1. The Shell sort algorithm is not a "stable" sort.  That is,
    --        the relative order of two records with equal sort keys is not
    --        maintained.
    --
    --     2. The Shell sort works best on data that is almost in order.

    ----------------------

    generic
	type Element is private;       -- has ":="
	type Index is (<>);
	type Element_Array is array (Index range <>) of Element;
	with function ">=" (Left, Right : Element) return Boolean;

    procedure Array_Quick_Sort (The_Table : in out Element_Array; 
				First_Element : Index; 
				Last_Element : Index);

    -- This procedure rearranges the Element_Array, in place, such that
    --      To_Be_Sorted(I) "<=" To_Be_Sorted(I+1)    for suitable I
    --
    -- The procedure uses a partition-exchange sort (also known as
    -- "Quick Sort") which is described in Knuth's Sorting and Searching.
    --
    -- CAUTIONS:
    --
    --      1. The nature of the algorithm causes it to perform best when
    --         the list is un-ordered, and perform worst when the list is
    --         already in order.
    --
    --      2. The quick_sort algorithm is not a "stable" sort.  That is,
    --         the relative order of two records with equal sort keys is
    --         not maintained.
    --
    --      3. The quick_sort algorithm depends upon ">=", a ">" causes
    --         the algorithm to fail.


end Sort_Utilities;
