package body Sort_Utilities is

    procedure Array_Shell_Sort 
		 (The_Table : in out Element_Array; Last_Element : Index) is

	Table : Element_Array renames The_Table 
					 (The_Table'First .. Last_Element);
	First_Index : Integer := Index'Pos (Table'First);
	Last_Index : Integer := Index'Pos (Table'Last);
	J : Integer;
	Jg : Integer;
	Gap : Integer;
	Temp : Element;
    begin

	Gap := Last_Index - First_Index;

	while Gap > 0 loop
	    for I in Index'Val (Gap + First_Index) .. Table'Last loop
		J := Index'Pos (I) - Gap;

		while J >= First_Index loop
		    Jg := J + Gap;

		    declare
			Op1 : Element renames Table (Index'Val (J));
			Op2 : Element renames Table (Index'Val (Jg));
		    begin
			if Op2 < Op1 then
			    Temp := Op1;
			    Op1 := Op2;
			    Op2 := Temp;
			else
			    exit;
			end if;
		    end;

		    J := J - Gap;
		end loop;
	    end loop;

	    Gap := Gap / 2;
	end loop;
    end Array_Shell_Sort;

    ------------------------------------------------------------

    procedure Array_Quick_Sort (The_Table : in out Element_Array; 
				First_Element : Index; 
				Last_Element : Index) is

	-- Steps labeled  Q1 .. Q9  correspond to the equivalent steps
	-- in Knuth's quick_sort example.

	Table : Element_Array renames The_Table (First_Element .. Last_Element);

	First : Integer := Index'Pos (Table'First);
	Last : Integer := Index'Pos (Table'Last);
	J_Minus_Left : Integer;
	Right_Minus_J : Integer;
	Exchange : Element;

	Subfile_Size : constant := 1;
	-- Since Subfile_size = 1, there is no step Q8

	procedure Quick_Sort (L : Integer; R : Integer) is

	    I : Integer;
	    J : Integer;
	    Left : Integer := L;
	    Right : Integer := R;
	    Key : Element;


-- (Q2)  Begin new stage

	begin

	    loop

		I := Left;
		J := Right + 1;
		Key := Table (Index'Val (Left));

-- (Q3)  Compare Key(i) to key

		loop

		    loop
			I := I + 1;
			exit when I > Last  
				     or else Table (Index'Val (I)) >= Key;
		    end loop;

-- (Q4) compare Key to key(j)

		    loop
			J := J - 1;
			exit when J < First  
				     or else Key >= Table (Index'Val (J));
		    end loop;

-- (Q5) test i, j

		    if J <= I then

			Exchange := Table (Index'Val (Left));
			Table (Index'Val (Left)) := Table (Index'Val (J));
			Table (Index'Val (J)) := Exchange;
			exit;       -- go to step Q7
-- (Q6)  exchange

		    else
			Exchange := Table (Index'Val (I));
			Table (Index'Val (I)) := Table (Index'Val (J));
			Table (Index'Val (J)) := Exchange;
			-- go to step Q3

		    end if;

		end loop;

-- (Q7)  Put on stack
--
-- Instead of pushing a left,right pair on the stack which denotes the
-- indexes of a subfile which still needs to be sorted, we recursively call
-- quick_sort.  This makes the sort use a "queue"  (first-in / first-out)
-- method of processing the subfile ranges instead of the stack mechanism
-- (last-in, first-out) which is demonstrated in Knuth's example.  This
-- change also means that there is no step Q9 (take off stack) needed.


		Right_Minus_J := Right - J;
		J_Minus_Left := J - Left;

		if Right_Minus_J > Subfile_Size and 
		   Subfile_Size >= J_Minus_Left then

		    Left := J + 1;

		elsif J_Minus_Left > Subfile_Size and 
		      Subfile_Size >= Right_Minus_J then

		    Right := J - 1;

		elsif Right_Minus_J >= J_Minus_Left and 
		      J_Minus_Left > Subfile_Size then

		    Quick_Sort (L => J + 1, R => Right);
		    Right := J - 1;

		elsif J_Minus_Left > Right_Minus_J and 
		      Right_Minus_J > Subfile_Size then

		    Quick_Sort (L => Left, R => J - 1);
		    Left := J + 1;

		else
		    return;
		    -- Since the sort is written as a recursive routine,
		    -- this replaces step Q9 (take off stack)

		end if;

		-- go to step Q2

	    end loop;

	end Quick_Sort;

    begin
	if Last - First >= 1 then
	    Quick_Sort (L => First, R => Last);
	end if;
    end Array_Quick_Sort;


end Sort_Utilities;
