generic
    type Element is private;

    pragma Must_Be_Constrained (Yes => Element);

package Stack_Generic is

    type Stack is private;
    Empty_Stack : constant Stack;
    -- It is expected that a declared stack is initialized to Empty_Stack

    procedure Make_Empty (S : in out Stack);
    procedure Pop (S : in out Stack);
    procedure Push (X : Element; S : in out Stack);
    function Empty (S : Stack) return Boolean;
    function Top (S : Stack) return Element;

    procedure Copy (Target : in out Stack; Source : Stack);

    Underflow : exception;


    type Iterator is private;

    procedure Init (Iter : out Iterator; S : Stack);
    procedure Next (Iter : in out Iterator);

    function Value (Iter : Iterator) return Element;
    function Done (Iter : Iterator) return Boolean;

    --/inline pragma Inline (make_empty);
    --/inline pragma Inline (empty);
    --/inline pragma Inline (top);
    --/inline pragma Inline (push);
    --/inline pragma Inline (pop);

    --/inline pragma Inline (init);
    --/inline pragma Inline (next);
    --/inline pragma Inline (value);
    --/inline pragma Inline (done);
private
    type Stack_Node;
    type Stack is access Stack_Node;
    Empty_Stack : constant Stack := null;
    type Iterator is new Stack;
end Stack_Generic;
