package body Stack_Generic is

    type Stack_Node is
	record
	    Elt : Element;
	    Link : Stack;
	end record;

    procedure Make_Empty (S : in out Stack) is
    begin
	S := null;
    end Make_Empty;

    procedure Pop (S : in out Stack) is
    begin
	if S = null then
	    raise Underflow;
	else
	    S := S.Link;
	end if;
    end Pop;


    procedure Push (X : Element; S : in out Stack) is
	New_Node : Stack;
    begin
	New_Node := new Stack_Node'(Elt => X, Link => S);
	S := New_Node;
    end Push;


    function Empty (S : Stack) return Boolean is
    begin
	return S = null;
    end Empty;


    function Top (S : Stack) return Element is
    begin
	if S = null then
	    raise Underflow;
	else
	    return S.Elt;
	end if;
    end Top;

    procedure Copy (Target : in out Stack; Source : Stack) is
	Rest_Of_Source : Stack;
	Last_Of_Target : Stack;
    begin
	if Source /= null then
	    Target := new Stack_Node'(Elt => Source.Elt, Link => null);

	    Last_Of_Target := Target;
	    Rest_Of_Source := Source.Link;
	    while Rest_Of_Source /= null loop
		Last_Of_Target.Link := 
		   new Stack_Node'(Elt => Rest_Of_Source.Elt, Link => null);
		Last_Of_Target := Last_Of_Target.Link;
		Rest_Of_Source := Rest_Of_Source.Link;
	    end loop;
	else
	    Target := null;
	end if;
    end Copy;

    procedure Init (Iter : out Iterator; S : Stack) is
    begin
	Iter := Iterator (S);
    end Init;

    procedure Next (Iter : in out Iterator) is
    begin
	Iter := Iterator (Iter.Link);
    end Next;

    function Value (Iter : Iterator) return Element is
    begin
	return Iter.Elt;
    end Value;

    function Done (Iter : Iterator) return Boolean is
    begin
	return Iter = null;
    end Done;

end Stack_Generic;
