with String_Utilities;

package body String_Map_Generic is

    function Find (S : Set; Name : String) return Set is
	Rest : Set := S;
    begin
	if Ignore_Case then
	    declare
		Upper_Name : constant String := 
		   String_Utilities.Upper_Case (Name);
	    begin
		while Rest /= null loop
		    if Rest.Name'Length = Upper_Name'Length and then 
		       String_Utilities.Upper_Case (Rest.Name) = Upper_Name then
			return Rest;
		    end if;
		    Rest := Rest.Link;
		end loop;
	    end;
	else
	    while Rest /= null loop
		if Rest.Name = Name then
		    return Rest;
		end if;
		Rest := Rest.Link;
	    end loop;
	end if;
	return null;
    end Find;

    function Hash (Name : String) return Index is
    begin
	return Index'(String_Utilities.Hash_String (Name) mod Size);
    end Hash;
    --/inline    pragma inline(hash);

    function Eval (The_Map : Map; D : String) return Range_Type is
	Ptr : Set := Find (The_Map.Bucket (Hash (D)), D);
    begin
	if Ptr /= null then
	    return Ptr.Value;
	else
	    raise Undefined;
	end if;
    end Eval;

    procedure Find (The_Map : Map; 
		    D : String; 
		    R : in out Range_Type; 
		    Success : out Boolean) is
	Ptr : Set := Find (The_Map.Bucket (Hash (D)), D);
    begin
	if Ptr /= null then
	    R := Ptr.Value;
	    Success := True;
	else
	    Success := False;
	end if;
    end Find;

    procedure Define (The_Map : in out Map; 
		      D : String; 
		      R : Range_Type; 
		      Trap_Multiples : Boolean := False) is
	This_Node : Set renames The_Map.Bucket (Hash (D));
	The_Set : Set := This_Node;
	Ptr : Set := Find (The_Set, D);
    begin
	if Ptr = null then
	    This_Node := new Node (D'Length);
	    declare
		N : Node renames This_Node.all;
	    begin
		N.Link := The_Set;
		N.Value := R;
		N.Name := D;
	    end;
	    The_Map.Size := The_Map.Size + 1;
	elsif Trap_Multiples then
	    raise Multiply_Defined;

	else
	    Ptr.Value := R;
	end if;
    end Define;

    procedure Undefine (The_Map : in out Map; D : String) is
	The_Bucket : Index := Hash (D);
	Current : Set := The_Map.Bucket (The_Bucket);
	Previous : Set := null;
    begin
	while Current /= null loop
	    if Current.Name = D then
		if Previous /= null then
		    Previous.Link := Current.Link;
		else
		    The_Map.Bucket (The_Bucket) := Current.Link;
		end if;
		The_Map.Size := The_Map.Size - 1;
		return;
	    else
		Previous := Current;
		Current := Current.Link;
	    end if;
	end loop;
	raise Undefined;
    end Undefine;

    procedure Copy (Target : in out Map; Source : Map) is
	Rest : Set;
    begin
	for I in Index loop
	    Rest := Source.Bucket (I);
	    Target.Bucket (I) := null;

	    while Rest /= null loop
		Target.Bucket (I) := new Node'(Size => Rest.Name'Length, 
					       Name => Rest.Name, 
					       Value => Rest.Value, 
					       Link => Target.Bucket (I));

		Rest := Rest.Link;
	    end loop;
	end loop;
	Target.Size := Source.Size;
    end Copy;

    procedure Initialize (The_Map : out Map) is
    begin
	The_Map := new Map_Data;
    end Initialize;


    function Is_Empty (The_Map : Map) return Boolean is
	Iter : Iterator;
    begin
	for I in Index loop
	    if The_Map.Bucket (I) /= null then
		return False;
	    end if;
	end loop;
	return True;
    end Is_Empty;

    procedure Make_Empty (The_Map : in out Map) is
    begin
	for I in Index loop
	    The_Map.Bucket (I) := null;
	end loop;  
	The_Map.Size := 0;
    end Make_Empty;

    procedure Init (Iter : out Iterator; The_Map : Map) is
	The_Iter : Iterator;
    begin
	for I in Index loop
	    The_Iter.Set_Iter := The_Map.Bucket (I);
	    if The_Iter.Set_Iter /= null then
		The_Iter.Done := False;
		The_Iter.Index_Value := I;
		The_Iter.The_Map := The_Map;
		Iter := The_Iter;
		return;
	    end if;
	end loop;
	The_Iter.Done := True;
	Iter := The_Iter;
    end Init;

    procedure Next (Iter : in out Iterator) is
    begin
	Iter.Set_Iter := Iter.Set_Iter.Link;

	while Iter.Set_Iter = null loop
	    if Iter.Index_Value = Index'Last then
		Iter.Done := True;
		return;
	    end if;
	    Iter.Index_Value := Iter.Index_Value + 1;
	    Iter.Set_Iter := Iter.The_Map.Bucket (Iter.Index_Value);
	end loop;
    end Next;

    function Value (Iter : Iterator) return String is
    begin
	return Iter.Set_Iter.Name;
    end Value;

    function Done (Iter : Iterator) return Boolean is
    begin
	return Iter.Done;
    end Done;

    function Nil return Map is
    begin
	return null;
    end Nil;

    function Is_Nil (The_Map : Map) return Boolean is
    begin
	return The_Map = null;
    end Is_Nil;

    function Cardinality (The_Map : Map) return Natural is
    begin
	return The_Map.Size;
    end Cardinality;
end String_Map_Generic;
