package String_Table is

    type Item is private;

    type Table is private;

    Table_Full : exception;

    -- create a table for unique strings
    function New_Table (Minimum_Table_Size : Natural := 127) return Table;

    function Nil return Item;

    -- return unique item in table, ignore_case => upper_case storage
    function Unique (Source : String; 
		     In_Table : Table; 
		     Ignore_Case : Boolean := True) return Item;

    -- return item if present, otherwise Nil
    function Find (Source : String; 
		   In_Table : Table; 
		   Ignore_Case : Boolean := True) return Item;

    -- return an item without entering in table
    function Allocate (Source : String; In_Table : Table) return Item;

    -- compare strings for identity, then same contents
    function Equal (L, R : Item) return Boolean;

    -- representation of string, suitable for hashing
    function Unique_Index (U : Item) return Integer;

    -- value of character or entire string
    function Char_At (Source : Item; At_Pos : Natural) return Character;
    function Image (Source : Item) return String;
    function Length (Source : Item) return Natural;
    function Is_Nil (Source : Item) return Boolean;

    type Iterator is private;

    procedure Init (Iter : out Iterator; The_Table : Table);
    procedure Next (Iter : in out Iterator);
    function Value (Iter : Iterator) return Item;
    function Done (Iter : Iterator) return Boolean;
private
    type Table_Storage;

    type Table is access Table_Storage;

    type Item is access String;

    type Sym_Rec;
    type Long_Sym_Pointer is access Sym_Rec;

    type Sym_Pointer is new Long_Sym_Pointer;

    subtype Element_Index is Integer;

    type Iterator is
	record
	    The_Table : Table;
	    Bucket : Element_Index;
	    Member : Long_Sym_Pointer;
	end record;

end String_Table;
