with Text_Io;

-- This package is used to produce neatly formatted tables with centered
-- headers and even amounts of white space between the columns.  The first
-- N calls should be to header, which defines a header and a type of
-- justification for the items that will go into each column.  Then the M*N
-- items of an M line table are sent into the package a row at a time.  An
-- item is defined by either a single call to Item, or a series of zero or
-- more calls to Subitem terminated by a call to Last_Subitem.  Multiple
-- parts of an item are separated by the subitem separator.  After all the
-- items have been defined, the table is output with a call to Display.

-- The package internally allocates enough memory to save a copy of the
-- entire table.   It is therefore a good idea to instantiate this
-- procedure in a local frame so that all the memory it allocates will go
-- away when the frame does.

generic
    Number_Of_Columns : Positive;
    Subitem_Separator : String := " ";
package Table_Formatter is

    type Adjust is (Left, Right, Centered);
    procedure Header (S : String; Format : Adjust := Left);
    procedure Item (S : String);
    procedure Subitem (S : String);
    procedure Last_Subitem;
    procedure Display (On_File : Text_Io.File_Type);


    type Field_List is array (Integer range <>) of Positive;
    procedure Sort (On_Field : Positive := 1);
    procedure Sort (On_Fields : Field_List);

end Table_Formatter;
