with Asis;
with Text_Io;
procedure Check_Storage_Error is
    View_Name : constant String := 
       "/export/projects/utilities/asis_utilities.ss/training.wrk";

    The_Library : Asis.Library;

    function Procedure_Handles_Storage_Error 
		(Body_Decl : Asis.Declaration) return Boolean is
	Exception_Handlers : constant Asis.Exception_Handler_List := 
	   Asis.Statements.Block_Exception_Handlers 
	      (Asis.Declarations.Subprogram_Body_Block (Body_Decl));
    begin
	for I in Exception_Handlers'Range loop
	    if not Asis.Statements.Is_Others_Handler 
		      (Exception_Handlers (I)) then
		declare
		    Exception_Names : constant Asis.Choice_List := 
		       Asis.Statements.Exception_Choices 
			  (Exception_Handlers (I));
		begin
		    for J in Exception_Names'Range loop
			if Asis.Expressions.Name 
			      (Asis.Type_Definitions.Choice_Name 
				  (Exception_Names (I))) = "STORAGE_ERROR" then
			    return True;
			end if;
		    end loop;
		end;
	    end if;
	end loop;
	return False;
    end Procedure_Handles_Storage_Error;

begin
    Asis.Environment.Initialize;
    Asis.Libraries.Associate (Library => The_Library, 
			      Name => Asis.Strings.To_Asis_String (View_Name));
    Asis.Libraries.Open (The_Library);

    declare
	All_Units : constant Asis.Compilation_Unit_List := 
	   Asis.Compilation_Units.Compilation_Units (The_Library);
	Unit_Decl : Asis.Declaration;
    begin
	for I in All_Units'Range loop
	    Unit_Decl := Asis.Compilation_Units.Unit_Declaration 
			    (All_Units (I));
	    case Asis.Declarations.Kind (Unit_Decl) is
		when Asis.Declarations.A_Procedure_Body_Declaration =>
		    if Procedure_Handles_Storage_Error (Unit_Decl) then
			Text_Io.Put_Line (Asis.Compilation_Units.Name 
					     (All_Units (I)) & 
					  " handles storage_error");
		    else
			Text_Io.Put_Line (Asis.Compilation_Units.Name 
					     (All_Units (I)) & 
					  " does not handle storage_error");

		    end if;
		when others =>
		    null;
	    end case;
	end loop;
    end;

    Asis.Libraries.Close (The_Library);
    Asis.Libraries.Dissociate (The_Library);
    Asis.Environment.Finalize;

exception
    when Storage_Error =>
	null;
end Check_Storage_Error;
