
with Asis;
with Text_Io;
procedure Display_Code_Violations is
    View_Name : constant String := 
       "/export/projects/utilities/asis_utilities.ss/training.wrk";

    The_Library : Asis.Library;

    type State_Info is (Not_Used);

    procedure Pre_Operation (Element : in Asis.Element; 
			     Control : in out Asis.Elements.Traverse_Control; 
			     State : in out State_Info) is
    begin
	case Asis.Elements.Element_Kind (Element) is
	    when Asis.Elements.A_Declaration =>
		case Asis.Declarations.Kind (Element) is
		    when Asis.Declarations.A_Parameter_Specification =>
			case Asis.Declarations.Parameter_Mode_Kind (Element) is
			    when Asis.Declarations.A_Default_In_Mode =>
				Text_Io.Put_Line 
				   ("Defuault in mode violation: " & 
				    Asis.Expressions.Name 
				       (Asis.Declarations.Names (Element) (1)) & 
				    " in " & Asis.Compilation_Units.Name 
						(Asis.Compilation_Units.
						 Enclosing_Compilation_Unit 
						    (Element)));
			    when others =>
				null;
			end case;
		    when others =>
			null;
		end case;
	    when others =>
		null;
	end case;
    end Pre_Operation;

    procedure Post_Operation (Element : in Asis.Element; 
			      Control : in out Asis.Elements.Traverse_Control; 
			      State : in out State_Info) is
    begin
	null;
    end Post_Operation;


    procedure Find_Violations is new Asis.Elements.Traverse_Element 
					(State_Information => State_Info, 
					 Pre_Operation => Pre_Operation, 
					 Post_Operation => Post_Operation);

begin
    Asis.Environment.Initialize;
    Asis.Libraries.Associate (Library => The_Library, 
			      Name => Asis.Strings.To_Asis_String (View_Name));
    Asis.Libraries.Open (The_Library);

    declare
	Dont_Care : State_Info := Not_Used;
	Control : Asis.Elements.Traverse_Control := Asis.Elements.Continue;
	All_Units : constant Asis.Compilation_Unit_List := 
	   Asis.Compilation_Units.Compilation_Units (The_Library);
    begin
	for I in All_Units'Range loop
	    Find_Violations (Element => Asis.Compilation_Units.Unit_Declaration 
					   (All_Units (I)), 
			     Control => Control, 
			     State => Dont_Care);
	end loop;
    end;

    Asis.Libraries.Close (The_Library);
    Asis.Libraries.Dissociate (The_Library);
    Asis.Environment.Finalize;
end Display_Code_Violations;
