with Asis;
with Text_Io;
procedure Display_Element is
    View_Name : constant String := 
       "/export/projects/utilities/asis_utilities.ss/training.wrk";
    Unit_Name : constant String := "DISPLAY_UNIT";
    The_Library : Asis.Library;
begin
    Asis.Environment.Initialize;
    Asis.Libraries.Associate (Library => The_Library, 
			      Name => Asis.Strings.To_Asis_String (View_Name));
    Asis.Libraries.Open (The_Library);

    declare
	The_Unit : Asis.Compilation_Unit;
	The_Decl : Asis.Declaration;
    begin
	The_Unit := Asis.Compilation_Units.Library_Unit 
		       (Name => Unit_Name, Library => The_Library);
	The_Decl := Asis.Compilation_Units.Unit_Declaration (The_Unit);
	Text_Io.Put_Line ("Unit decl kind is " & 
			  Asis.Declarations.Declaration_Kinds'Image 
			     (Asis.Declarations.Kind (The_Decl)));
	Text_Io.Put_Line ("It starts on line " & 
			  Asis.Line_Number'Image 
			     (Asis.Text.First_Line_Number (The_Decl)));
    end;

    Asis.Libraries.Close (The_Library);
    Asis.Libraries.Dissociate (The_Library);
    Asis.Environment.Finalize;
end Display_Element;

