with Asis;
with Text_Io;
procedure Display_Unit is
    View_Name : constant String := 
       "/export/projects/utilities/asis_utilities.ss/training.wrk";
    Unit_Name : constant String := "DISPLAY_UNIT";
    The_Library : Asis.Library;
begin
    Asis.Environment.Initialize;
    Asis.Libraries.Associate (Library => The_Library, 
			      Name => Asis.Strings.To_Asis_String (View_Name));
    Asis.Libraries.Open (The_Library);

    declare
	The_Unit : Asis.Compilation_Unit;
    begin
	The_Unit := Asis.Compilation_Units.Library_Unit 
		       (Name => Unit_Name, Library => The_Library);
	Text_Io.Put_Line ("Unit full pathname is " & 
			  Asis.Strings.To_Standard_String 
			     (Asis.Compilation_Units.Unique_Name (The_Unit)));
    end;

    Asis.Libraries.Close (The_Library);
    Asis.Libraries.Dissociate (The_Library);
    Asis.Environment.Finalize;
end Display_Unit;

