with Asis;
with Text_Io;
procedure Display_Visible_Types is  
    View_Name : constant String := 
       "/export/projects/utilities/asis_utilities.ss/training.wrk";

    The_Library : Asis.Library;

    procedure Check_Visible_Decls  
		 (The_Decls : in Asis.Declaration_List) is
    begin  
	for I in The_Decls'Range loop
	    case Asis.Elements.Element_Kind (The_Decls (I)) is
		when Asis.Elements.A_Declaration =>
		    case Asis.Declarations.Kind (The_Decls (I)) is
			when Asis.Declarations.A_Full_Type_Declaration | 
			     Asis.Declarations.A_Subtype_Declaration =>
			    Text_Io.Put_Line 
			       (Asis.Expressions.Name 
				   (Asis.Declarations.Names (The_Decls (I)) 
				       (1)) & 
				" in " & Asis.Compilation_Units.Name 
					    (Asis.Compilation_Units.
					     Enclosing_Compilation_Unit 
						(The_Decls (I))));
			when Asis.Declarations.A_Package_Declaration | 
			     Asis.Declarations.A_Generic_Package_Declaration =>
			    Check_Visible_Decls 
			       (Asis.Declarations.Visible_Part_Declarative_Items 
				   (The_Decls (I)));
			when others =>
			    null;
		    end case;
		when others =>
		    null;
	    end case;
	end loop;
    end Check_Visible_Decls;


begin
    Asis.Environment.Initialize;
    Asis.Libraries.Associate (Library => The_Library, 
			      Name => Asis.Strings.To_Asis_String (View_Name));
    Asis.Libraries.Open (The_Library);

    declare
	All_Units : constant Asis.Compilation_Unit_List := 
	   Asis.Compilation_Units.Compilation_Units (The_Library);
	Unit_Decl : Asis.Declaration;
    begin  
	for I in All_Units'Range loop  
	    Unit_Decl := Asis.Compilation_Units.Unit_Declaration 
			    (All_Units (I));
	    case Asis.Declarations.Kind (Unit_Decl) is
		when Asis.Declarations.A_Package_Declaration | 
		     Asis.Declarations.A_Generic_Package_Declaration =>
		    Check_Visible_Decls 
		       (Asis.Declarations.Visible_Part_Declarative_Items 
			   (Unit_Decl));
		when others =>
		    null;
	    end case;
	end loop;
    end;

    Asis.Libraries.Close (The_Library);
    Asis.Libraries.Dissociate (The_Library);
    Asis.Environment.Finalize;

end Display_Visible_Types;
