with Asis;
with Asis_Renames;
use Asis_Renames;
with Debug_Tools;
with Library_Utilities;
with Posix;
with Posix_Process_Environment;
with Text_Io;
procedure Display_Visible_Types_Final is  
    View_Name : constant String := 
       Posix.To_String (Posix.Value 
			   (Posix_Process_Environment.Argument_List, 2));

    The_Library : Asis.Library;
    Success : Boolean;

    procedure Check_Visible_Decls  
		 (The_Decls : in Asis.Declaration_List) is
    begin  
	for I in The_Decls'Range loop
	    case Asis.Elements.Element_Kind (The_Decls (I)) is
		when Asis.Elements.A_Declaration =>
		    case Decls.Kind (The_Decls (I)) is
			when Decls.A_Full_Type_Declaration | 
			     Decls.A_Subtype_Declaration =>
			    Text_Io.Put_Line 
			       (Exprs.Name (Decls.Names (The_Decls (I)) (1)) & 
				" in " & 
				Comp_Units.Name 
				   (Comp_Units.Enclosing_Compilation_Unit 
				       (The_Decls (I))));
			when Decls.A_Package_Declaration | 
			     Decls.A_Generic_Package_Declaration =>
			    Check_Visible_Decls 
			       (Decls.Visible_Part_Declarative_Items 
				   (The_Decls (I)));
			when others =>
			    null;
		    end case;
		when others =>
		    null;
	    end case;
	end loop;
    end Check_Visible_Decls;


begin
    Library_Utilities.Initialize (This_Library => The_Library, 
				  Unit_Or_View_Name => View_Name, 
				  Success => Success);

    declare
	All_Units : constant Asis.Compilation_Unit_List := 
	   Library_Utilities.Compilation_Units_In_View 
	      (Library => The_Library, View_Name => View_Name);
	Unit_Decl : Asis.Declaration;
    begin  
	for I in All_Units'Range loop  
	    Unit_Decl := Comp_Units.Unit_Declaration (All_Units (I));
	    case Decls.Kind (Unit_Decl) is
		when Decls.A_Package_Declaration | 
		     Decls.A_Generic_Package_Declaration =>
		    Check_Visible_Decls 
		       (Decls.Visible_Part_Declarative_Items (Unit_Decl));
		when others =>
		    null;
	    end case;
	end loop;
    end;

    Library_Utilities.Finalize (The_Library);

exception
    when Asis.Asis_Failed | Asis.Asis_Inappropriate_Element =>
	Text_Io.Put_Line ("*** ASIS Exception: " & 
			  To_String (Asis.Environment.Diagnosis));
    when others =>
	Text_Io.Put_Line ("*** Unknown Exception: " & 
			  Debug_Tools.Get_Exception_Name);
end Display_Visible_Types_Final;
