with Asis;
with Text_Io;
procedure Display_Withs is
    View_Name : constant String := 
       "/export/projects/utilities/asis_utilities.ss/training.wrk";
    Unit_Name : constant String := "DISPLAY_UNIT";
    The_Library : Asis.Library;
begin
    Asis.Environment.Initialize;
    Asis.Libraries.Associate (Library => The_Library, 
			      Name => Asis.Strings.To_Asis_String (View_Name));
    Asis.Libraries.Open (The_Library);

    declare
	The_Unit : Asis.Compilation_Unit := 
	   Asis.Compilation_Units.Library_Unit 
	      (Name => Unit_Name, Library => The_Library);
	Context_Clauses : constant Asis.Context_Clause_List := 
	   Asis.Compilation_Units.Context_Clause_Elements (The_Unit);
    begin
	for I in Context_Clauses'Range loop
	    case Asis.Elements.Element_Kind (Context_Clauses (I)) is
		when Asis.Elements.A_With_Clause =>
		    declare
			The_Refs : constant Asis.Simple_Name_List := 
			   Asis.Compilation_Units.Referenced_Units 
			      (Context_Clauses (I));
		    begin
			for J in The_Refs'Range loop
			    Text_Io.Put_Line 
			       ("This unit withs " & 
				Asis.Expressions.Name (The_Refs (J)));
			end loop;
		    end;
		when others =>
		    null;
	    end case;
	end loop;
    end;

    Asis.Libraries.Close (The_Library);
    Asis.Libraries.Dissociate (The_Library);
    Asis.Environment.Finalize;
end Display_Withs;

