with Asis_Renames;
use Asis_Renames;
with Text_Io;
package body Asis_Elem_Utilities is

    use Asis.Numerics.Operations;

    Nil_List : Asis.Line_List (1 .. 0);

    function Comments_Before 
		(This_Element : Asis.Element) return Asis.Line_List is
	Start_With : Asis.Line_Number;
	Current_Line : Asis.Line_Number;
	End_With : Asis.Line_Number := 0;
    begin
	Start_With := Asis.Text.First_Line_Number (This_Element) - 1;

	if Start_With > 0 then
	    Current_Line := Start_With;
	    loop
		-- see if the line above has a comment
		declare
		    This_Line : constant Asis.Line_List := 
		       Asis.Text.Lines 
			  (This_Element, Current_Line, Current_Line);
		begin
		    if To_String (Asis.Text.Comment_Image 
				     (This_Line (This_Line'First))) = "" then
			exit;  
		    else
			End_With := Current_Line;
			if Current_Line = 1 then
			    exit;
			else
			    Current_Line := Current_Line - 1;
			end if;
		    end if;
		end;
	    end loop;
	end if;

	if End_With = 0 then
	    return Nil_List;
	else
	    return Asis.Text.Lines (Element => This_Element, 
				    First_Line => End_With, 
				    Last_Line => Start_With);
	end if;
    end Comments_Before;


    function Comments_Below (Starting_With_This_Line : Asis.Line_Number; 
			     Base_Element : Asis.Element) 
			    return Asis.Line_List is
	End_With : Asis.Line_Number := 0;
	Current_Line : Asis.Line_Number;
    begin
	Current_Line := Starting_With_This_Line;
	loop
	    -- see if the line below has a comment
	    declare
		This_Line : constant Asis.Line_List := 
		   Asis.Text.Lines (Base_Element, Current_Line, Current_Line);
	    begin
		if To_String 
		      (Asis.Text.Comment_Image (This_Line (This_Line'First))) = 
		   "" then
		    exit;  
		else
		    End_With := Current_Line;
		    Current_Line := Current_Line + 1;
		end if;
	    end;
	end loop;

	if End_With = 0 then
	    return Nil_List;
	else
	    return Asis.Text.Lines (Element => Base_Element, 
				    First_Line => Starting_With_This_Line, 
				    Last_Line => End_With);
	end if;
    end Comments_Below;


    function Comments_After (This_Element : Asis.Element) 
			    return Asis.Line_List is
    begin
	return Comments_Below (Starting_With_This_Line => 
				  Asis.Text.Last_Line_Number (This_Element) + 1, 
			       Base_Element => This_Element);
    end Comments_After;


    function Comments_Within 
		(This_Element : Asis.Element) return Asis.Line_List is
    begin
	return Comments_Below 
		  (Starting_With_This_Line => 
		      Asis.Text.First_Line_Number (This_Element) + 1, 
		   Base_Element => This_Element);
    end Comments_Within;


    function Image (Of_Element : Asis.Element) return String is
    begin
	return To_String (Asis.Text.Image (Of_Element));
    end Image;


    procedure Put_Image_Summary (Of_Element : Asis.Element) is
	The_Span : Asis.Span;
    begin
	The_Span := Asis.Text.Element_Span (Of_Element);
	if The_Span.Last_Line = 0 then
	    return;

	elsif The_Span.Last_Line <= The_Span.First_Line + 2 then  -- 1..3 lines
	    declare
		The_Lines : constant Asis.Line_List := 
		   Asis.Text.Lines (Of_Element, The_Span.First_Line, 
				    The_Span.Last_Line);
	    begin
		for Line in The_Lines'Range loop
		    Text_Io.Put_Line (Asis.Line_Number'Image (Line) & ": " &  
				      To_String (Asis.Text.Image 
						    (The_Lines (Line))));
		end loop;
	    end;

	else  -- more than three lines
	    declare
		First_Line : constant Asis.Line_List := 
		   Asis.Text.Lines (Of_Element, The_Span.First_Line, 
				    The_Span.First_Line);
		Last_Line : constant Asis.Line_List := 
		   Asis.Text.Lines (Of_Element, The_Span.Last_Line, 
				    The_Span.Last_Line);
	    begin
		Text_Io.Put_Line 
		   (Asis.Line_Number'Image (The_Span.First_Line) & ": " &  
		    To_String (Asis.Text.Image 
				  (First_Line (First_Line'First))));
		Text_Io.Put_Line ("...");
		Text_Io.Put_Line 
		   (Asis.Line_Number'Image (The_Span.Last_Line) & ": " &  
		    To_String (Asis.Text.Image (Last_Line (Last_Line'First))));

	    end;
	end if;
    end Put_Image_Summary;

end Asis_Elem_Utilities;
