with Asis_Renames;
use Asis_Renames;  
with String_Map_Generic;
package body Comp_Unit_Utilities is

    package With_Maps is new String_Map_Generic (256, Boolean);
    The_Map : With_Maps.Map;


    function Withed_Units (By_Unit : Asis.Compilation_Unit) 
			  return Asis.Compilation_Unit_List is
    begin
	declare
	    Context_Clauses : constant Asis.Context_Clause_List := 
	       Comp_Units.Context_Clause_Elements (By_Unit);
	begin
	    With_Maps.Make_Empty (The_Map);
	    for I in Context_Clauses'Range loop
		case Asis_Elems.Element_Kind (Context_Clauses (I)) is
		    when Asis_Elems.A_With_Clause =>
			declare
			    The_Refs : constant Asis.Simple_Name_List := 
			       Comp_Units.Referenced_Units 
				  (Context_Clauses (I));
			begin
			    for J in The_Refs'Range loop
				With_Maps.Define 
				   (The_Map => The_Map, 
				    D => Exprs.Name (The_Refs (J)), 
				    R => True, 
				    Trap_Multiples => False);
			    end loop;
			end;
		    when others =>
			null;
		end case;
	    end loop;

	    if With_Maps.Cardinality (The_Map) > 0 then
		declare  
		    The_Units : Asis.Compilation_Unit_List 
				   (1 .. Asis.Asis_Natural 
					    (With_Maps.Cardinality (The_Map)));
		    The_Iter : With_Maps.Iterator;
		begin  
		    With_Maps.Init (The_Iter, The_Map);
		    for Unit in The_Units'Range loop
			The_Units (Unit) := 
			   Comp_Units.Library_Unit 
			      (With_Maps.Value (The_Iter), 
			       Comp_Units.Enclosing_Library (By_Unit));
			With_Maps.Next (The_Iter);
		    end loop;

		    return The_Units;  
		end;  
	    else
		return Asis.Nil_Compilation_Unit_List;
	    end if;
	end;
    exception
	when others =>
	    return Asis.Nil_Compilation_Unit_List;
    end Withed_Units;

begin
    With_Maps.Initialize (The_Map);
end Comp_Unit_Utilities;
