with Asis_Renames;
use Asis_Renames;
with String_Utilities;
package body Decl_Utilities is
    function Enclosing_Declaration 
		(This_Element : Asis.Element) return Asis.Declaration is
	use Decls.Operations;
	The_Decl : Asis.Declaration := This_Element;
    begin
	while Decls.Kind (The_Decl) = Decls.Not_A_Declaration loop
	    The_Decl := Asis.Elements.Enclosing_Element (The_Decl);
	end loop;
	return The_Decl;
    end Enclosing_Declaration;


    function Is_Unit_Declaration (This_Element : Asis.Element) return Boolean is
	The_Unit_Decl : Asis.Declaration := 
	   Comp_Units.Unit_Declaration 
	      (Comp_Units.Enclosing_Compilation_Unit (This_Element));
    begin
	return Asis.Elements.Is_Equal (This_Element, The_Unit_Decl);
    end Is_Unit_Declaration;


    function Located_In_Decl_List (The_Declaration : Asis.Declaration; 
				   In_List : Asis.Element_List; 
				   Check_Visible : Boolean; 
				   Check_Private : Boolean) return Boolean is
	A_Decl : Asis.Declaration;
	use Decls.Operations;
    begin
	for I in In_List'Range loop
	    A_Decl := In_List (I);
	    if Asis_Elems.Is_Identical (A_Decl, The_Declaration) then
		return True;
	    elsif Decls.Kind (A_Decl) = Decls.A_Package_Declaration then
		if Check_Visible then
		    if Located_In_Decl_List 
			  (The_Declaration, 
			   Decls.Visible_Part_Declarative_Items 
			      (A_Decl, Include_Pragmas => False), Check_Visible, 
			   Check_Private) then
			return True;
		    end if;
		end if;
		if Check_Private then
		    if Located_In_Decl_List 
			  (The_Declaration, 
			   Decls.Private_Part_Declarative_Items 
			      (A_Decl, Include_Pragmas => False), Check_Visible, 
			   Check_Private) then
			return True;
		    end if;
		end if;
	    end if;
	end loop;
	return False;
    end Located_In_Decl_List;

    function Is_Visible (This_Declaration : Asis.Declaration) return Boolean is
	The_Parent : Asis.Declaration := 
	   Comp_Units.Unit_Declaration 
	      (Comp_Units.Enclosing_Compilation_Unit (This_Declaration));
    begin  
	if Asis_Elems.Is_Equal (The_Parent, This_Declaration) then
	    case Comp_Units.Kind (Comp_Units.Enclosing_Compilation_Unit 
				     (This_Declaration)) is
		when Comp_Units.A_Subprogram_Declaration | 
		     Comp_Units.A_Package_Declaration | 
		     Comp_Units.A_Generic_Declaration | 
		     Comp_Units.A_Generic_Instantiation =>
		    return True;
		when others =>
		    return False;
	    end case;
	else
	    case Decls.Kind (The_Parent) is
		when Decls.A_Package_Declaration =>
		    return Located_In_Decl_List 
			      (This_Declaration, 
			       Decls.Visible_Part_Declarative_Items 
				  (The_Parent, Include_Pragmas => False), 
			       Check_Visible => True, 
			       Check_Private => False);
		when others =>
		    return False;
	    end case;
	end if;
    end Is_Visible;


    function Is_Private (This_Declaration : Asis.Declaration) return Boolean is
	The_Parent : Asis.Declaration := 
	   Comp_Units.Unit_Declaration 
	      (Comp_Units.Enclosing_Compilation_Unit (This_Declaration));
    begin  
	case Decls.Kind (The_Parent) is
	    when Decls.A_Package_Declaration =>
		return Located_In_Decl_List 
			  (This_Declaration, 
			   Decls.Private_Part_Declarative_Items 
			      (The_Parent, Include_Pragmas => False), 
			   Check_Visible => False, 
			   Check_Private => True);
	    when others =>
		return False;
	end case;
    end Is_Private;


    function Qualified_Reference (Decl : Asis.Declaration) return String is
	Parent_Comp_Unit_Name : constant String := 
	   Comp_Units.Name (Comp_Units.Enclosing_Compilation_Unit (Decl));

	function Parent_Name (Decl : Asis.Declaration) return String is
	    Enclosing : Asis.Declaration := 
	       Enclosing_Declaration (Asis.Elements.Enclosing_Element (Decl));
	begin
	    if not Is_Unit_Declaration (Enclosing) then
		Enclosing := Enclosing_Declaration 
				(Asis.Elements.Enclosing_Element (Enclosing));
	    end if;

	    declare
		Name : constant String := Exprs.Name 
					     (Decls.Names (Enclosing) (1));
	    begin
		if String_Utilities.Equal 
		      (Name, Parent_Comp_Unit_Name, Ignore_Case => True) then
		    return Name;
		else
		    return Parent_Name (Enclosing) & "." & Name;
		end if;
	    end;
	end Parent_Name;
    begin
	if Is_Unit_Declaration (Decl) or 
	   String_Utilities.Equal ("Standard", Parent_Comp_Unit_Name, 
				   Ignore_Case => True) then
	    return Exprs.Name (Decls.Names (Decl) (1));
	else
	    return Parent_Name (Decl) & "." & 
		      Exprs.Name (Decls.Names (Decl) (1));
	end if;
    end Qualified_Reference;

end Decl_Utilities;
