with Asis;
package Library_Utilities is

    procedure Initialize (This_Library : in out Asis.Library; 
			  Unit_Or_View_Name : String; 
			  Success : out Boolean);
    -- initializes the library, usually based on the first non-option
    -- command line argument. The Unit_Or_View_Name can be a full pathname,
    -- or a simple .ada name; in the latter case, the library is
    -- initialized based on the current working directory
    -- The procedure calls Environment.Initialize, Libraries.Associate,
    -- and Libraries.Open

    procedure Finalize (This_Library : in out Asis.Library);
    -- Calls Libraries.Close, Libaries.Dissociate, and Environment.Finalize


    function Compilation_Units_In_View 
		(Library : in Asis.Library;  
		 View_Name : in String) return Asis.Compilation_Unit_List;
    -- given the full pathname of a view, returns the set of compilation
    -- units contained in that view

    function Corresponding_Unit (For_Unix_File_Name : String; 
				 Within_Library : Asis.Library) 
				return Asis.Compilation_Unit;
    -- given a simple unix pathname, or a full one, determine the comp unit
    -- returns Nil_Compilation_Unit if unsuccessful

end Library_Utilities;
