with Asis_Renames;
use Asis_Renames;
with Pathnames;
with String_Utilities;
with Unbounded;
package body Library_Utilities is

    procedure Initialize (This_Library : in out Asis.Library; 
			  Unit_Or_View_Name : String; 
			  Success : out Boolean) is
	Library_Name : Unbounded.Variable_String;
    begin
	if Unit_Or_View_Name (Unit_Or_View_Name'First) = '/' then
	    Library_Name := Unbounded.Value 
			       (Pathnames.Enclosing_View (Unit_Or_View_Name));
	else
	    Library_Name := Unbounded.Value (Pathnames.Enclosing_View);
	end if;
	declare
	    The_Library_Name : constant String := 
	       Unbounded.Image (Library_Name);
	begin
	    if The_Library_Name = "" then
		Success := False;
	    else
		Asis.Environment.Initialize;
		Asis.Libraries.Associate 
		   (This_Library, Asis.Strings.To_Asis_String 
				     (The_Library_Name));
		Asis.Libraries.Open (This_Library);
		Success := True;
	    end if;
	end;  
    exception
	when others =>
	    Success := False;
    end Initialize;


    procedure Finalize (This_Library : in out Asis.Library) is
    begin
	Asis.Libraries.Close (This_Library);
	Asis.Libraries.Dissociate (This_Library);
	Asis.Environment.Finalize;
    end Finalize;


    function Compilation_Units_In_View 
		(Library : in Asis.Library; View_Name : in String) 
		return Asis.Compilation_Unit_List is
	All_Units : constant Asis.Compilation_Unit_List := 
	   Comp_Units.Compilation_Units (Library);
	Units_In_View : Asis.Compilation_Unit_List (All_Units'Range);
	Num_Units_In_View : Natural := 0;
    begin
	for I in All_Units'Range loop
	    declare
		The_Unique_Name : constant String := 
		   To_String (Comp_Units.Unique_Name (All_Units (I)));
	    begin
		if String_Utilities.Locate 
		      (View_Name, The_Unique_Name, Ignore_Case => True) = 
		   The_Unique_Name'First then
		    Num_Units_In_View := Num_Units_In_View + 1;
		    Units_In_View (Asis.Numerics.List_Index 
				      (Num_Units_In_View)) := All_Units (I);
		end if;
	    end;
	end loop;  
	if Num_Units_In_View > 0 then
	    return Units_In_View (1 .. Asis.Numerics.List_Index 
					  (Num_Units_In_View));
	else
	    return Asis.Nil_Compilation_Unit_List;
	end if;
    end Compilation_Units_In_View;


    function Corresponding_Unit (For_Unix_File_Name : String; 
				 Within_Library : Asis.Library) 
				return Asis.Compilation_Unit is

	-- this decl is required due to a strange bug in ASIS
	All_Units : constant Asis.Compilation_Unit_List := 
	   Compilation_Units_In_View (Within_Library, "");
	Last_Slash : Natural := String_Utilities.Reverse_Locate 
				   ('/', For_Unix_File_Name);
    begin
	-- check length first
	if For_Unix_File_Name'Last < For_Unix_File_Name'First + 6 then
	    return Asis.Nil_Compilation_Unit;
	elsif For_Unix_File_Name 
		 (For_Unix_File_Name'Last - 5 .. For_Unix_File_Name'Last) = 
	      ".1.ada" then
	    if Last_Slash = 0 then
		return Comp_Units.Library_Unit 
			  (String_Utilities.Upper_Case 
			      (For_Unix_File_Name 
				  (For_Unix_File_Name'First .. 
				      For_Unix_File_Name'Last - 6)), 
			   Within_Library);
	    else
		return Comp_Units.Library_Unit 
			  (String_Utilities.Upper_Case 
			      (For_Unix_File_Name 
				  (Last_Slash + 1 .. 
				      For_Unix_File_Name'Last - 6)), 
			   Within_Library);
	    end if;
	elsif For_Unix_File_Name 
		 (For_Unix_File_Name'Last - 5 .. For_Unix_File_Name'Last) = 
	      ".2.ada" then
	    if Last_Slash = 0 then
		return Comp_Units.Secondary_Unit 
			  (String_Utilities.Upper_Case 
			      (For_Unix_File_Name 
				  (For_Unix_File_Name'First .. 
				      For_Unix_File_Name'Last - 6)), 
			   Within_Library);
	    else
		return Comp_Units.Secondary_Unit 
			  (String_Utilities.Upper_Case 
			      (For_Unix_File_Name 
				  (Last_Slash + 1 .. 
				      For_Unix_File_Name'Last - 6)), 
			   Within_Library);
	    end if;
	else
	    return Asis.Nil_Compilation_Unit;
	end if;
    end Corresponding_Unit;

end Library_Utilities;
