with Posix;
with Posix_Process_Environment;
with String_Utilities;
with Unix_Operations;
with Unix_Types;
package body Pathnames is

    function Get_Cwd return String is
    begin
	return Posix.To_String (Posix_Process_Environment.
				Get_Working_Directory);
    end Get_Cwd;


    function Enclosing_View (For_This_Full_Path : String) return String is
	Dot_Wrk_Loc : Natural := String_Utilities.Reverse_Locate 
				    (".wrk", For_This_Full_Path);
	Dot_Rel_Loc : Natural := String_Utilities.Reverse_Locate 
				    (".rel", For_This_Full_Path);
    begin
	if Dot_Wrk_Loc > 0 then
	    return For_This_Full_Path (For_This_Full_Path'First .. Dot_Wrk_Loc);
	elsif Dot_Rel_Loc > 0 then
	    return For_This_Full_Path (For_This_Full_Path'First .. Dot_Rel_Loc);
	else
	    return "";
	end if;
    end Enclosing_View;

    function Enclosing_View return String is
	Current_Working_Dir : constant String := Get_Cwd;
    begin
	return Enclosing_View (Current_Working_Dir);
    end Enclosing_View;

    function Get_Temp_Filename return String is
	Result : constant Unix_Types.Char_Ptr := Unix_Operations.Tmpnam (null);
    begin
	if Unix_Types."=" (Result, null) then
	    return "";
	    --Errors.Raze (Errno_Condition ("tmpnam"));
	end if;

	return Unix_Types.To_String (Result);
    end Get_Temp_Filename;
end Pathnames;
