with Asis_Renames;
use Asis_Renames;
package body Stmt_Utilities is

    use Statements.Operations, Decls.Operations;

    function Enclosing_Stmt (For_Element : Asis.Element) 
			    return Asis.Statement is
	Parent : Asis.Element := Asis_Elems.Enclosing_Element (For_Element);
    begin
	while not Asis_Elems.Is_Nil (Parent) and then 
		 Statements.Kind (Parent) = Statements.Not_A_Statement loop
	    case Decls.Kind (Parent) is
		when Decls.Not_A_Declaration | 
		     Decls.A_Loop_Parameter_Specification =>
		    Parent := Asis_Elems.Enclosing_Element (Parent);
		when others =>
		    Parent := Asis.Nil_Element;
	    end case;
	end loop;
	return Parent;
    end Enclosing_Stmt;


    function Enclosing_Loop (For_Element : Asis.Element) 
			    return Asis.Statement is
	Parent : Asis.Element := Enclosing_Stmt (For_Element);
    begin
	while not Asis_Elems.Is_Nil (Parent) and then 
		 Statements.Kind (Parent) /= Statements.A_Loop_Statement loop
	    Parent := Enclosing_Stmt (Parent);
	end loop;
	return Parent;
    end Enclosing_Loop;


    function Enclosing_Block 
		(For_Element : Asis.Element) return Asis.Statement is
	Parent : Asis.Element := Enclosing_Stmt (For_Element);
    begin
	while not Asis_Elems.Is_Nil (Parent) and then 
		 Statements.Kind (Parent) /= Statements.A_Block_Statement loop
	    Parent := Enclosing_Stmt (Parent);
	end loop;
	return Parent;
    end Enclosing_Block;


    function Is_Explicitly_Declared 
		(This_Block : Asis.Statement) return Boolean is
    begin
	return Decls.Kind (Asis_Elems.Enclosing_Element (This_Block)) = 
		  Decls.Not_A_Declaration;
    end Is_Explicitly_Declared;

end Stmt_Utilities;
