-- ============================================================================
-- >>>>>>>>>>>>>>>>>>>>>>>>>> ADA COMPILATION UNIT <<<<<<<<<<<<<<<<<<<<<<<<<<<<
-- ============================================================================
--
-- NAME:        Command
--
--              SPECIFICATION
-- 
-- AUTHOR:      Chuck Hobin
--
-- DATE:        5 March 1994
--
--                               CHANGE HISTORY
--
-- MM-DD-YY | Initials | Description
-- ----------------------------------------------------------------------------
-- <include SPR#, if applicable>
-- ============================================================================

package Command is

    -- This package provides functions to convert the unix variable
    -- argv to Ada style arrays and strings.  It presents an invariant
    -- interface, hiding environment-specific operations for accessing
    -- argv.

    type String_Ptr is access String;

    type String_Ptr_Array is array (Integer range <>) of String_Ptr;

    function Argc return Natural;
    -- Number of command line arguments including the command itself

    function Arguments return String_Ptr_Array;
    -- Returns an array (0..Argc-1) of pointers to strings

end Command;

