-- ============================================================================
-- >>>>>>>>>>>>>>>>>>>>>>>>>> ADA COMPILATION UNIT <<<<<<<<<<<<<<<<<<<<<<<<<<<<
-- ============================================================================
--
-- NAME:        Control_Flow_Scan
--
--              SPECIFICATION
--
-- AUTHOR:      Pilar Montes
--              General Research Corporation
--
--                            CHANGE 
--
-- MM-DD-YY | Initials | Description 
-- ---------------------------------------------------------------------------
-- <include SPR#, if applicable>
-- ===========================================================================
-- ===========================================================================

with Asis;
with Control_Flow_Defs;

package Control_Flow_Scan is


    package Cf_Defs renames Control_Flow_Defs;


------------------------------------------------------------------------------
-- Build_Control_Flow_View
-- 
-- Constructs a control flow view by traversing the ASIS elements of a 
-- program unit body.  The input element is expected to be one of the 
-- following Asis.Declarations.Declaration_Kinds:
-- 
--   A_Procedure_Body_Declaration
--   A_Function_Body_Declaration
--   A_Task_Body_Declaration
--   A_Package_Body_Declaration
--
-- NOTE: ASIS exceptions raised during the execution of this operation
-- propagate to the caller; no attempt is made to handle them within.
------------------------------------------------------------------------------

    function Build_Control_Flow_View (Body_Decl : in Asis.Declaration) 
				     return Cf_Defs.Control_Flow_View;

end Control_Flow_Scan;
