--| +=========================================================================+
--| |                                                                         |
--| | NAMESPACE_SCAN.SCAN_COMPONENT_CLAUSE (body)                             |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Namespace_Scan)
procedure Scan_Component_Clause (The_Clause : in Asis.Component_Clause; 
				 The_Context : in Context) is

    Cuid : constant String := "Namespace_Scan.Scan_Component_Clause";
    Puid : constant String := "Scan_Component_Clause";

    package Error renames Namespace_Scan.Error_Handling_Support;
    package Trace renames Namespace_Scan.Trace_Support;

begin

    if Namespace_Scan.Obeying_Regions and then 
       Rgn.Denotes_One_Or_More_Regions (The_Clause) then
	declare
	    Remaining_Parent_Elements : constant Asis.Element_List := 
	       Rgn.Non_Region_Subelements 
		  (The_Clause, Include_Pragmas => False);
	begin
	    Namespace_Scan.Scan_Any_List 
	       (Remaining_Parent_Elements, The_Clause);
	end;
	return;
    end if;

    declare
	Address : Asis.Expression := 
	   Asis_Rc.Component_Clause_Relative_Address (The_Clause);
	Name : Asis.Simple_Name := Asis_Rc.Component_Clause_Name (The_Clause);
	The_Range : Asis.Range_Constraint := 
	   Asis_Rc.Component_Clause_Range (The_Clause);
    begin

	if Trace.On then
	    Trace.Log (The_Clause);
	    Trace.Add_Level (3);
	end if;

	Namespace_Scan.Scan_Expression (Name, The_Context);

	Namespace_Scan.Scan_Expression (Address, The_Context);

	Namespace_Scan.Scan_Discrete_Range (The_Range, The_Context);

    end;

exception

    when Asis.Asis_Inappropriate_Element =>
	Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Clause);
	raise Traversal_Error;

    when Asis.Asis_Failed =>
	Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Clause);
	raise Traversal_Error;

    when Traversal_Error =>
	Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Clause);
	raise;

end Scan_Component_Clause;
