--| +=========================================================================+
--| |                                                                         |
--| | NAMESPACE_SCAN.SCAN_DECLARATIVE_REGION_PART (body)                      |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Namespace_Scan)
procedure Scan_Declarative_Region_Part 
	     (The_Region : in Rgn.Region; The_Context : in Context) is

    Cuid : constant String := "Namespace_Scan.Scan_Declarative_Region_Part";
    Puid : constant String := "Scan_Declarative_Region_Part";

    package Error renames Namespace_Scan.Error_Handling_Support;
    package Trace renames Namespace_Scan.Trace_Support;

begin

    declare
	Subelements : constant Asis.Element_List := 
	   Rgn.Subelements (The_Region, Include_Pragmas => False);
    begin

	if Rgn."=" (Rgn.Kind (The_Region), Rgn.A_Compilation_Unit) then
	    if Trace.On then
		Trace.Log (Rgn.Head_Unit (The_Region));
		Trace.Add_Level (Subelements'Length + 1);
	    end if;
	    Namespace_Scan.Scan_Any_List (Subelements, Asis.Nil_Element);
	else
	    if Trace.On then
		Trace.Log (Rgn.Head_Element (The_Region));
		Trace.Add_Level (Subelements'Length + 1);
	    end if;
	    Namespace_Scan.Scan_Any_List (Subelements, 
					  Rgn.Head_Element (The_Region));
	end if;

    end;

exception

    when Traversal_Error =>
	if Rgn."=" (Rgn.Kind (The_Region), Rgn.A_Compilation_Unit) then
	    Error.Log (Error.A_Previous_Error, Cuid, 
		       Puid, Rgn.Head_Unit (The_Region));
	else
	    Error.Log (Error.A_Previous_Error, Cuid, Puid, 
		       Rgn.Head_Element (The_Region));
	end if;
	raise;

end Scan_Declarative_Region_Part;
