--| +=========================================================================+
--| |                                                                         |
--| | NAMESPACE_SCAN.SCAN_PRAGMA (body)                                       |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Namespace_Scan)
procedure Scan_Pragma (The_Pragma : in Asis.Pragma_Element; 
		       The_Context : in Context) is

    Cuid : constant String := "Namespace_Scan.Scan_Pragma";
    Puid : constant String := "Scan_Pragma";

    package Error renames Namespace_Scan.Error_Handling_Support;
    package Trace renames Namespace_Scan.Trace_Support;

begin

    if Namespace_Scan.Obeying_Regions and then 
       Rgn.Denotes_One_Or_More_Regions (The_Pragma) then
	declare
	    Remaining_Parent_Elements : constant Asis.Element_List := 
	       Rgn.Non_Region_Subelements 
		  (The_Pragma, Include_Pragmas => False);
	begin
	    Namespace_Scan.Scan_Any_List 
	       (Remaining_Parent_Elements, The_Pragma);
	end;
	return;
    end if;

    declare
	Arguments : constant Asis.Argument_Association_List := 
	   Asis_E.Argument_Associations (The_Pragma);
    begin

	if Trace.On then
	    Trace.Log (The_Pragma);
	    Trace.Add_Level (Arguments'Length);
	end if;

	Namespace_Scan.Scan_Argument_Association_List (Arguments, The_Context);

    end;

exception

    when Asis.Asis_Inappropriate_Element =>
	Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Pragma);
	raise Traversal_Error;

    when Asis.Asis_Failed =>
	Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Pragma);
	raise Traversal_Error;

    when Traversal_Error =>
	Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Pragma);
	raise;

end Scan_Pragma;
