--| +=========================================================================+
--| |                                                                         |
--| | REFERENCE_SCAN.SCAN_COMPILATION_UNIT (body)                             |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Reference_Scan)
procedure Scan_Compilation_Unit 
	     (The_Unit : in Asis.Compilation_Unit; The_Context : in Context) is

    Cuid : constant String := "Reference_Scan.Scan_Compilation_Unit";
    Puid : constant String := "Scan_Compilation_Unit";

    package Ctx renames Reference_Scan.Context_Support;
    package Error renames Reference_Scan.Error_Handling_Support;
    package Trace renames Reference_Scan.Trace_Support;

begin

    declare
	Context_Clauses : constant Asis.Context_Clause_List := 
	   Asis_Cu.Context_Clause_Elements 
	      (The_Unit, Reference_Scan.Include_Context_Clause_Pragmas);
	Declared_Unit : Asis.Declaration := Asis_Cu.Unit_Declaration (The_Unit);
    begin

	if Trace.On then
	    Trace.Log (The_Unit, The_Context);
	    Trace.Add_Level (Context_Clauses'Length + 1);
	end if;

	Reference_Scan.Scan_Context_Clause_List 
	   (Context_Clauses, Ctx.Set (The_Context, 
				      Basic_Context => Rvs.A_Use_Context_Clause, 
				      Weight => 85));

	Reference_Scan.Scan_Declaration (Declared_Unit, The_Context);

    end;

exception

    when Asis.Asis_Inappropriate_Compilation_Unit =>
	Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Unit);
	raise Traversal_Error;

    when Asis.Asis_Failed =>
	Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Unit);
	raise Traversal_Error;

    when Traversal_Error =>
	Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Unit);
	raise;

end Scan_Compilation_Unit;
