--| +=========================================================================+
--| |                                                                         |
--| | REFERENCE_SCAN.SCAN_SELECT_ALTERNATIVE (body)                           |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Reference_Scan)
procedure Scan_Select_Alternative (The_Alternative : in Asis.Select_Alternative; 
				   The_Context : in Context) is

    Cuid : constant String := "Reference_Scan.Scan_Select_Alternative";
    Puid : constant String := "Scan_Select_Alternative";

    package Ctx renames Reference_Scan.Context_Support;
    package Error renames Reference_Scan.Error_Handling_Support;
    package Trace renames Reference_Scan.Trace_Support;

begin

    declare
	Guard_Expression : Asis.Expression := Asis_S.Guard (The_Alternative);
	Statements : constant Asis.Statement_List := 
	   Asis_S.Select_Alternative_Statements 
	      (The_Alternative, Reference_Scan.
				   Include_Select_Statement_Pragmas);
    begin

	if Trace.On then
	    Trace.Log (The_Alternative, The_Context);
	    Trace.Add_Level (Reference_Scan.One_If_Present (Guard_Expression) + 
			     Statements'Length);
	end if;

	if not Asis_E.Is_Nil (Guard_Expression) then
	    Reference_Scan.Scan_Expression 
	       (Guard_Expression, 
		Ctx.Set (The_Context, 
			 Basic_Context => Rvs.A_Read, 
			 Weight => 5, 
			 Add_Data_Access_Context => Rvs.A_Select_Alternative));
	end if;

	Reference_Scan.Scan_Statement_List (Statements, The_Context);

    end;

exception

    when Asis.Asis_Inappropriate_Element =>
	Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Alternative);
	raise Traversal_Error;

    when Asis.Asis_Failed =>
	Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Alternative);
	raise Traversal_Error;

    when Traversal_Error =>
	Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Alternative);
	raise;

end Scan_Select_Alternative;
