--| +=========================================================================+
--| |                                                                         |
--| | REGION_SCAN.REGION_SCAN_INTERNAL.SCAN_CASE_STATEMENT_ALTERNATIVE_LIST   |
--| | (body)                                                                  |
--| |                                                                         |
--| | Scans a list of case statement alternatives and pragmas.                |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Region_Scan.Region_Scan_Internal)
procedure Scan_Case_Statement_Alternative_List 
	     (The_List : in Asis.Case_Statement_Alternative_List; 
	      The_Context : in out Context) is

    Cuid : constant String := 
       "Region_Scan.Region_Scan_Internal.Scan_Case_Statement_Alternative_List";
    Puid : constant String := "Scan_Case_Statement_Alternative_List";

    package Error renames Region_Scan_Internal.Error_Handling_Support;

    The_Element : Asis.Element;

begin

    for I in The_List'Range loop
	The_Element := The_List (I);
	case Asis_E.Element_Kind (The_Element) is
	    when Asis_E.A_Case_Statement_Alternative =>
		Region_Scan_Internal.Scan_Case_Statement_Alternative 
		   (The_Element, The_Context);
	    when Asis_E.A_Pragma =>
		Region_Scan_Internal.Scan_Pragma (The_Element, The_Context);
	    when others =>
		Error.Log (Error.An_Unhandled_Case, Cuid, Puid, The_Element);
		if Region_Scan_Internal.Raise_Exception_On_Unhandled_Case then
		    raise Traversal_Error;
		end if;
	end case;
    end loop;

end Scan_Case_Statement_Alternative_List;
