--| +=========================================================================+
--| |                                                                         |
--| | REGION_SCAN.REGION_SCAN_INTERNAL.SCAN_DECLARATIVE_ITEM_LIST (body)      |
--| |                                                                         |
--| | Scans a list of declarations, pragmas, representation clauses, and      |
--| | use clauses.                                                            |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Region_Scan.Region_Scan_Internal)
procedure Scan_Declarative_Item_List (The_List : in Asis.Declarative_Item_List; 
				      The_Context : in out Context) is

    Cuid : constant String := 
       "Region_Scan.Region_Scan_Internal.Scan_Declarative_Item_List";
    Puid : constant String := "Scan_Declarative_Item_List";

    package Error renames Region_Scan_Internal.Error_Handling_Support;

    The_Element : Asis.Element;

begin

    for I in The_List'Range loop
	The_Element := The_List (I);
	case Asis_E.Element_Kind (The_Element) is
	    when Asis_E.A_Declaration =>
		Region_Scan_Internal.Scan_Declaration 
		   (The_Element, The_Context);
	    when Asis_E.A_Pragma =>
		Region_Scan_Internal.Scan_Pragma (The_Element, The_Context);
	    when Asis_E.A_Representation_Clause =>
		Region_Scan_Internal.Scan_Representation_Clause 
		   (The_Element, The_Context);
	    when Asis_E.A_Use_Clause =>
		Region_Scan_Internal.Scan_Use_Clause (The_Element, The_Context);
	    when others =>
		Error.Log (Error.An_Unhandled_Case, Cuid, Puid, The_Element);
		if Region_Scan_Internal.Raise_Exception_On_Unhandled_Case then
		    raise Traversal_Error;
		end if;
	end case;
    end loop;

end Scan_Declarative_Item_List;
