--| +=========================================================================+
--| |                                                                         |
--| | SCAN.SCAN_CASE_STATEMENT_ALTERNATIVE (body)                             |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Scan)
procedure Scan_Case_Statement_Alternative 
	     (The_Alternative : in Asis.Case_Statement_Alternative; 
	      The_Context : in out Context) is

    Cuid : constant String := "Scan.Scan_Case_Statement_Alternative";
    Puid : constant String := "Scan_Case_Statement_Alternative";

    package Error renames Scan.Error_Handling_Support;
    package Trace renames Scan.Trace_Support;

begin

    declare
	Choices : constant Asis.Choice_List := 
	   Asis_S.Case_Statement_Alternative_Choices (The_Alternative);
	Statements : constant Asis.Statement_List := 
	   Asis_S.Case_Statement_Alternative_Statements 
	      (The_Alternative, Scan.Include_Case_Statement_Pragmas);
    begin

	if Trace.On then
	    Trace.Log (The_Alternative);
	    Trace.Add_Level (Choices'Length + Statements'Length);
	end if;

	Scan.Scan_Choice_List (Choices, The_Context);

	Scan.Scan_Statement_List (Statements, The_Context);

    end;

exception

    when Asis.Asis_Inappropriate_Element =>
	Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Alternative);
	raise Traversal_Error;

    when Asis.Asis_Failed =>
	Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Alternative);
	raise Traversal_Error;

    when Traversal_Error =>
	Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Alternative);
	raise;

end Scan_Case_Statement_Alternative;
