--| +=========================================================================+
--| |                                                                         |
--| | ASIS_DEBUG_SUPPORT - miscellaneous debug-related subprograms            |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

with Asis;

package Asis_Debug_Support is

--| Compilation_Unit_Image returns a textual representation of an Asis
--| compilation unit.  The representation consists of the unit's origin, kind,
--| and name and possibly other information.  For example:
--|
--|     A_USER_DEFINED_UNIT A_PACKAGE_DECLARATION "FOOBAR" (obsolete)
--|
--| A newline is NOT included in the formatting.

    function Compilation_Unit_Image 
		(The_Unit : in Asis.Compilation_Unit) return String;

--| Element_Image returns a textual representation of an Asis element.
--| The representation consists of the element's kind and sub-kinds and
--| possibly other information.  For example:
--|
--|     A_STATEMENT A_LOOP_STATEMENT A_WHILE_LOOP (labeled)
--|
--| A newline is NOT included in the formatting.

    function Element_Image (The_Element : in Asis.Element) return String;

end Asis_Debug_Support;
