--| +=========================================================================+
--| |                                                                         |
--| | CONTROL_FLOW_VIEW - an Asis abstraction                                 |
--| |                                                                         |
--| | This package provides operations to construct and manage the            |
--| | control flow view of a program unit body.  The view is a directed       |
--| | graph, where the nodes in the graph represent executable statements and |
--| | the edges represent possible transfers of control between statements.   |
--| |                                                                         |
--| | Pilar Montes                                                            |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

with Asis;
with Control_Flow_Defs;
with Text_Io;

package Control_Flow_View is

--------------------------------------------------------------------------------
-- Construct
-- 
-- Creates a control flow view for a program unit body.  The input 
-- Asis element must be A_Declaration of one of the following 
-- Asis.Declarations.Declaration_Kinds:
-- 
--   A_Procedure_Body_Declaration
--   A_Function_Body_Declaration
--   A_Task_Body_Declaration
--   A_Package_Body_Declaration
--
-- Raises : Inappropriate_Element, if element of any other kind is input.
--------------------------------------------------------------------------------

    procedure Construct (The_View : in out Control_Flow_Defs.Control_Flow_View; 
			 For_Body : in Asis.Declaration);

---------------------------------------------------------------------------------- Free
-- Free
--
-- Frees all memory held by a control flow view.  The_View is set to null.
--------------------------------------------------------------------------------

    procedure Free (The_View : in out Control_Flow_Defs.Control_Flow_View);

--------------------------------------------------------------------------------
-- Dump
-- 
-- Writes a textual representation of a control flow view to a file for
-- debugging purposes.
--------------------------------------------------------------------------------

    procedure Dump (The_View : in Control_Flow_Defs.Control_Flow_View; 
		    To_The_File : in Text_Io.File_Type := 
		       Text_Io.Standard_Output);

    Inappropriate_Element : exception;

end Control_Flow_View;

