--| +=========================================================================+
--| |                                                                         |
--| | NAMESPACE_SCAN.SCAN_COMPONENT_ASSOCIATION (body)                        |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Namespace_Scan)
procedure Scan_Component_Association 
	     (The_Association : in Asis.Component_Association; 
	      The_Context : in Context) is

    Cuid : constant String := "Namespace_Scan.Scan_Component_Association";
    Puid : constant String := "Scan_Component_Association";

    package Error renames Namespace_Scan.Error_Handling_Support;
    package Trace renames Namespace_Scan.Trace_Support;

begin

    if Namespace_Scan.Obeying_Regions and then 
       Rgn.Denotes_One_Or_More_Regions (The_Association) then
	declare
	    Remaining_Parent_Elements : constant Asis.Element_List := 
	       Rgn.Non_Region_Subelements 
		  (The_Association, Include_Pragmas => False);
	begin
	    Namespace_Scan.Scan_Any_List 
	       (Remaining_Parent_Elements, The_Association);
	end;
	return;
    end if;

    declare
	Actual_Part : Asis.Expression := 
	   Asis_X.Component_Expression (The_Association);
	Formal_Part : constant Asis.Choice_List := 
	   Asis_X.Component_Choices (The_Association);
    begin

	if Trace.On then
	    Trace.Log (The_Association);
	    Trace.Add_Level (Formal_Part'Length + 1);
	end if;

	Namespace_Scan.Scan_Choice_List (Formal_Part, The_Context);

	Namespace_Scan.Scan_Expression (Actual_Part, The_Context);

    end;

exception

    when Asis.Asis_Inappropriate_Element =>
	Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Association);
	raise Traversal_Error;

    when Asis.Asis_Failed =>
	Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Association);
	raise Traversal_Error;

    when Traversal_Error =>
	Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Association);
	raise;

end Scan_Component_Association;
