--| +=========================================================================+
--| |                                                                         |
--| | NAMESPACE_SCAN.SCAN_ENTITY_NAME_DEFINITION (body)                       |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Namespace_Scan)
procedure Scan_Entity_Name_Definition 
	     (The_Definition : in Asis.Entity_Name_Definition; 
	      The_Context : in Context) is

    Cuid : constant String := "Namespace_Scan.Scan_Entity_Name_Definition";
    Puid : constant String := "Scan_Entity_Name_Definition";

    package Error renames Namespace_Scan.Error_Handling_Support;
    package Trace renames Namespace_Scan.Trace_Support;

    H : Definition_Holder_Ptr;

begin

    if Trace.On then
	Trace.Log (The_Definition);
    end if;

    if Asis_E.Is_Nil (The_Context) then
	Error.Malformed_Definition_Error (The_Definition);
    end if;

    H := new Definition_Holder;
    H.Element := The_Definition;
    H.Parent := The_Context;
    H.Next := Namespace_Scan.Definition_List;
    Namespace_Scan.Definition_List := H;

end Scan_Entity_Name_Definition;
