--| +=========================================================================+
--| |                                                                         |
--| | NAMESPACE_SCAN.SCAN_EXCEPTION_HANDLER (body)                            |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Namespace_Scan)
procedure Scan_Exception_Handler (The_Handler : in Asis.Exception_Handler; 
				  The_Context : in Context) is

    Cuid : constant String := "Namespace_Scan.Scan_Exception_Handler";
    Puid : constant String := "Scan_Exception_Handler";

    package Error renames Namespace_Scan.Error_Handling_Support;
    package Trace renames Namespace_Scan.Trace_Support;

begin

    if Namespace_Scan.Obeying_Regions and then 
       Rgn.Denotes_One_Or_More_Regions (The_Handler) then
	declare
	    Remaining_Parent_Elements : constant Asis.Element_List := 
	       Rgn.Non_Region_Subelements 
		  (The_Handler, Include_Pragmas => False);
	begin
	    Namespace_Scan.Scan_Any_List 
	       (Remaining_Parent_Elements, The_Handler);
	end;
	return;
    end if;

    declare
	Choices : constant Asis.Choice_List := 
	   Asis_S.Exception_Choices (The_Handler);
	Statements : constant Asis.Statement_List := 
	   Asis_S.Handler_Statements 
	      (The_Handler, Namespace_Scan.Include_Exception_Handler_Pragmas);
    begin

	if Trace.On then
	    Trace.Log (The_Handler);
	    Trace.Add_Level (Choices'Length + Statements'Length);
	end if;

	Namespace_Scan.Scan_Choice_List (Choices, The_Context);

	Namespace_Scan.Scan_Statement_List (Statements, The_Context);

    end;

exception

    when Asis.Asis_Inappropriate_Element =>
	Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Handler);
	raise Traversal_Error;

    when Asis.Asis_Failed =>
	Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Handler);
	raise Traversal_Error;

    when Traversal_Error =>
	Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Handler);
	raise;

end Scan_Exception_Handler;
