--| +=========================================================================+
--| |                                                                         |
--| | NAMESPACE_SCAN.SCAN_IF_STATEMENT_ARM (body)                             |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Namespace_Scan)
procedure Scan_If_Statement_Arm 
	     (The_Arm : in Asis.If_Statement_Arm; The_Context : in Context) is

    Cuid : constant String := "Namespace_Scan.Scan_If_Statement_Arm";
    Puid : constant String := "Scan_If_Statement_Arm";

    package Error renames Namespace_Scan.Error_Handling_Support;
    package Trace renames Namespace_Scan.Trace_Support;

--| +-------------------------------------------------------------------------+
--| | SCAN_ELSE_ARM (local)                                                   |
--| +-------------------------------------------------------------------------+

    procedure Scan_Else_Arm (The_Arm : in Asis.If_Statement_Arm; 
			     The_Context : in Context) is

	Puid : constant String := "Scan_Else_Arm";

    begin

	declare
	    Statements : constant Asis.Statement_List := 
	       Asis_S.Arm_Statements 
		  (The_Arm, Namespace_Scan.Include_If_Statement_Pragmas);
	begin

	    if Trace.On then
		Trace.Log (The_Arm);
		Trace.Add_Level (Statements'Length);
	    end if;

	    Namespace_Scan.Scan_Statement_List (Statements, The_Context);

	end;

    exception

	when Asis.Asis_Inappropriate_Element =>
	    Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Arm);
	    raise Traversal_Error;

	when Asis.Asis_Failed =>
	    Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Arm);
	    raise Traversal_Error;

	when Traversal_Error =>
	    Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Arm);
	    raise;

    end Scan_Else_Arm;

--| +-------------------------------------------------------------------------+
--| | SCAN_ELSIF_ARM (local)                                                  |
--| +-------------------------------------------------------------------------+

    procedure Scan_Elsif_Arm (The_Arm : in Asis.If_Statement_Arm; 
			      The_Context : in Context) is

	Puid : constant String := "Scan_Elsif_Arm";

    begin

	declare
	    Condition : Asis.Expression := 
	       Asis_S.Condition_Expression (The_Arm);
	    Statements : constant Asis.Statement_List := 
	       Asis_S.Arm_Statements 
		  (The_Arm, Namespace_Scan.Include_If_Statement_Pragmas);
	begin

	    if Trace.On then
		Trace.Log (The_Arm);
		Trace.Add_Level (1 + Statements'Length);
	    end if;

	    Namespace_Scan.Scan_Expression (Condition, The_Context);

	    Namespace_Scan.Scan_Statement_List (Statements, The_Context);

	end;

    exception

	when Asis.Asis_Inappropriate_Element =>
	    Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Arm);
	    raise Traversal_Error;

	when Asis.Asis_Failed =>
	    Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Arm);
	    raise Traversal_Error;

	when Traversal_Error =>
	    Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Arm);
	    raise;

    end Scan_Elsif_Arm;

--| +-------------------------------------------------------------------------+
--| | SCAN_IF_ARM (local)                                                     |
--| +-------------------------------------------------------------------------+

    procedure Scan_If_Arm (The_Arm : in Asis.If_Statement_Arm; 
			   The_Context : in Context) is

	Puid : constant String := "Scan_If_Arm";

    begin

	declare
	    Condition : Asis.Expression := 
	       Asis_S.Condition_Expression (The_Arm);
	    Statements : constant Asis.Statement_List := 
	       Asis_S.Arm_Statements 
		  (The_Arm, Namespace_Scan.Include_If_Statement_Pragmas);
	begin

	    if Trace.On then
		Trace.Log (The_Arm);
		Trace.Add_Level (1 + Statements'Length);
	    end if;

	    Namespace_Scan.Scan_Expression (Condition, The_Context);

	    Namespace_Scan.Scan_Statement_List (Statements, The_Context);

	end;

    exception

	when Asis.Asis_Inappropriate_Element =>
	    Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Arm);
	    raise Traversal_Error;

	when Asis.Asis_Failed =>
	    Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Arm);
	    raise Traversal_Error;

	when Traversal_Error =>
	    Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Arm);
	    raise;

    end Scan_If_Arm;

--| +-------------------------------------------------------------------------+
--| | SCAN_IF_STATEMENT_ARM (exported)                                        |
--| +-------------------------------------------------------------------------+

begin

    if Namespace_Scan.Obeying_Regions and then 
       Rgn.Denotes_One_Or_More_Regions (The_Arm) then
	declare
	    Remaining_Parent_Elements : constant Asis.Element_List := 
	       Rgn.Non_Region_Subelements (The_Arm, Include_Pragmas => False);
	begin
	    Namespace_Scan.Scan_Any_List (Remaining_Parent_Elements, The_Arm);
	end;
	return;
    end if;

    case Asis_S.If_Statement_Arm_Kind (The_Arm) is
	when Asis_S.An_If_Arm =>
	    Scan_If_Arm (The_Arm, The_Context);
	when Asis_S.An_Elsif_Arm =>
	    Scan_Elsif_Arm (The_Arm, The_Context);
	when Asis_S.An_Else_Arm =>
	    Scan_Else_Arm (The_Arm, The_Context);
	when Asis_S.Not_An_If_Statement_Arm =>
	    Error.Log (Error.An_Unhandled_Case, Cuid, Puid, The_Arm);
	    if Namespace_Scan.Raise_Exception_On_Unhandled_Case then
		raise Traversal_Error;
	    else
		if Trace.On then
		    Trace.Log (The_Arm);
		end if;
	    end if;
    end case;

end Scan_If_Statement_Arm;
