--| +=========================================================================+
--| |                                                                         |
--| | REFERENCE_SCAN.SCAN_ARGUMENT_ASSOCIATION (body)                         |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Reference_Scan)
procedure Scan_Argument_Association (The_Association : in Asis.Association; 
				     The_Context : in Context) is

    Cuid : constant String := "Reference_Scan.Scan_Argument_Association";
    Puid : constant String := "Scan_Argument_Association";

    package Error renames Reference_Scan.Error_Handling_Support;
    package Trace renames Reference_Scan.Trace_Support;

begin

    declare
	Actual_Part : Asis.Expression := 
	   Asis_S.Actual_Parameter (The_Association);
    begin

	if Trace.On then
	    Trace.Log (The_Association, The_Context);
	    Trace.Add_Level (1);
	end if;

	Reference_Scan.Scan_Expression (Actual_Part, The_Context);

    end;

exception

    when Asis.Asis_Inappropriate_Element =>
	Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Association);
	raise Traversal_Error;

    when Asis.Asis_Failed =>
	Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Association);
	raise Traversal_Error;

    when Traversal_Error =>
	Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Association);
	raise;

end Scan_Argument_Association;
