--| +=========================================================================+
--| |                                                                         |
--| | REFERENCE_SCAN.SCAN_COMPONENT_CLAUSE (body)                             |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Reference_Scan)
procedure Scan_Component_Clause (The_Clause : in Asis.Component_Clause; 
				 The_Context : in Context) is

    Cuid : constant String := "Reference_Scan.Scan_Component_Clause";
    Puid : constant String := "Scan_Component_Clause";

    package Ctx renames Reference_Scan.Context_Support;
    package Error renames Reference_Scan.Error_Handling_Support;
    package Trace renames Reference_Scan.Trace_Support;

begin

    declare
	Address : Asis.Expression := 
	   Asis_Rc.Component_Clause_Relative_Address (The_Clause);
	Name : Asis.Simple_Name := Asis_Rc.Component_Clause_Name (The_Clause);
	The_Range : Asis.Range_Constraint := 
	   Asis_Rc.Component_Clause_Range (The_Clause);
    begin

	if Trace.On then
	    Trace.Log (The_Clause, The_Context);
	    Trace.Add_Level (3);
	end if;

	Reference_Scan.Scan_Expression 
	   (Name, Ctx.Set (The_Context, 
			   Basic_Context => Rvs.A_Component_Clause, 
			   Weight => 90));

	Reference_Scan.Scan_Expression 
	   (Address, Ctx.Set 
			(The_Context, 
			 Basic_Context => Rvs.A_Read, 
			 Weight => 5, 
			 Add_Data_Access_Context => Rvs.A_Component_Clause));

	Reference_Scan.Scan_Discrete_Range 
	   (The_Range, Ctx.Set 
			  (The_Context, 
			   Basic_Context => Rvs.A_Read, 
			   Weight => 5, 
			   Add_Data_Access_Context => Rvs.A_Component_Clause));

    end;

exception

    when Asis.Asis_Inappropriate_Element =>
	Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Clause);
	raise Traversal_Error;

    when Asis.Asis_Failed =>
	Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Clause);
	raise Traversal_Error;

    when Traversal_Error =>
	Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Clause);
	raise;

end Scan_Component_Clause;
