--| +=========================================================================+
--| |                                                                         |
--| | REFERENCE_SCAN.SCAN_COMPONENT_CLAUSE_LIST (body)                        |
--| |                                                                         |
--| | Scans a list of record representation component clauses and pragmas.    |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Reference_Scan)
procedure Scan_Component_Clause_List (The_List : in Asis.Component_Clause_List; 
				      The_Context : in Context) is

    Cuid : constant String := "Reference_Scan.Scan_Component_Clause_List";
    Puid : constant String := "Scan_Component_Clause_List";

    package Error renames Reference_Scan.Error_Handling_Support;
    package Trace renames Reference_Scan.Trace_Support;

    The_Element : Asis.Element;

begin

    for I in The_List'Range loop
	The_Element := The_List (I);
	case Asis_E.Element_Kind (The_Element) is
	    when Asis_E.A_Component_Clause =>
		Reference_Scan.Scan_Component_Clause (The_Element, The_Context);
	    when Asis_E.A_Pragma =>
		Reference_Scan.Scan_Pragma (The_Element, The_Context);
	    when others =>
		Error.Log (Error.An_Unhandled_Case, Cuid, Puid, The_Element);
		if Reference_Scan.Raise_Exception_On_Unhandled_Case then
		    raise Traversal_Error;
		else
		    if Trace.On then
			Trace.Log (The_Element, The_Context);
		    end if;
		end if;
	end case;
    end loop;

end Scan_Component_Clause_List;
