--| +=========================================================================+
--| |                                                                         |
--| | REFERENCE_SCAN.SCAN_EXCEPTION_HANDLER (body)                            |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Reference_Scan)
procedure Scan_Exception_Handler (The_Handler : in Asis.Exception_Handler; 
				  The_Context : in Context) is

    Cuid : constant String := "Reference_Scan.Scan_Exception_Handler";
    Puid : constant String := "Scan_Exception_Handler";

    package Error renames Reference_Scan.Error_Handling_Support;
    package Trace renames Reference_Scan.Trace_Support;

begin

    declare
	Choices : constant Asis.Choice_List := 
	   Asis_S.Exception_Choices (The_Handler);
	Statements : constant Asis.Statement_List := 
	   Asis_S.Handler_Statements 
	      (The_Handler, Reference_Scan.Include_Exception_Handler_Pragmas);
    begin

	if Trace.On then
	    Trace.Log (The_Handler, The_Context);
	    Trace.Add_Level (Choices'Length + Statements'Length);
	end if;

	Reference_Scan.Scan_Choice_List (Choices, The_Context);

	Reference_Scan.Scan_Statement_List (Statements, The_Context);

    end;

exception

    when Asis.Asis_Inappropriate_Element =>
	Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Handler);
	raise Traversal_Error;

    when Asis.Asis_Failed =>
	Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Handler);
	raise Traversal_Error;

    when Traversal_Error =>
	Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Handler);
	raise;

end Scan_Exception_Handler;
