--| +=========================================================================+
--| |                                                                         |
--| | REFERENCE_SCAN.SCAN_IF_STATEMENT_ARM (body)                             |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Reference_Scan)
procedure Scan_If_Statement_Arm 
	     (The_Arm : in Asis.If_Statement_Arm; The_Context : in Context) is

    Cuid : constant String := "Reference_Scan.Scan_If_Statement_Arm";
    Puid : constant String := "Scan_If_Statement_Arm";

    package Ctx renames Reference_Scan.Context_Support;
    package Error renames Reference_Scan.Error_Handling_Support;
    package Trace renames Reference_Scan.Trace_Support;

--| +-------------------------------------------------------------------------+
--| | SCAN_ELSE_ARM (local)                                                   |
--| +-------------------------------------------------------------------------+

    procedure Scan_Else_Arm (The_Arm : in Asis.If_Statement_Arm; 
			     The_Context : in Context) is

	Puid : constant String := "Scan_Else_Arm";

    begin

	declare
	    Statements : constant Asis.Statement_List := 
	       Asis_S.Arm_Statements 
		  (The_Arm, Reference_Scan.Include_If_Statement_Pragmas);
	begin

	    if Trace.On then
		Trace.Log (The_Arm, The_Context);
		Trace.Add_Level (Statements'Length);
	    end if;

	    Reference_Scan.Scan_Statement_List (Statements, The_Context);

	end;

    exception

	when Asis.Asis_Inappropriate_Element =>
	    Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Arm);
	    raise Traversal_Error;

	when Asis.Asis_Failed =>
	    Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Arm);
	    raise Traversal_Error;

	when Traversal_Error =>
	    Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Arm);
	    raise;

    end Scan_Else_Arm;

--| +-------------------------------------------------------------------------+
--| | SCAN_ELSIF_ARM (local)                                                  |
--| +-------------------------------------------------------------------------+

    procedure Scan_Elsif_Arm (The_Arm : in Asis.If_Statement_Arm; 
			      The_Context : in Context) is

	Puid : constant String := "Scan_Elsif_Arm";

    begin

	declare
	    Condition : Asis.Expression := 
	       Asis_S.Condition_Expression (The_Arm);
	    Statements : constant Asis.Statement_List := 
	       Asis_S.Arm_Statements 
		  (The_Arm, Reference_Scan.Include_If_Statement_Pragmas);
	begin

	    if Trace.On then
		Trace.Log (The_Arm, The_Context);
		Trace.Add_Level (1 + Statements'Length);
	    end if;

	    Reference_Scan.Scan_Expression 
	       (Condition, Ctx.Set 
			      (The_Context, 
			       Basic_Context => Rvs.A_Read, 
			       Weight => 5, 
			       Add_Data_Access_Context => Rvs.An_If_Condition));

	    Reference_Scan.Scan_Statement_List (Statements, The_Context);

	end;

    exception

	when Asis.Asis_Inappropriate_Element =>
	    Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Arm);
	    raise Traversal_Error;

	when Asis.Asis_Failed =>
	    Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Arm);
	    raise Traversal_Error;

	when Traversal_Error =>
	    Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Arm);
	    raise;

    end Scan_Elsif_Arm;

--| +-------------------------------------------------------------------------+
--| | SCAN_IF_ARM (local)                                                     |
--| +-------------------------------------------------------------------------+

    procedure Scan_If_Arm (The_Arm : in Asis.If_Statement_Arm; 
			   The_Context : in Context) is

	Puid : constant String := "Scan_If_Arm";

    begin

	declare
	    Condition : Asis.Expression := 
	       Asis_S.Condition_Expression (The_Arm);
	    Statements : constant Asis.Statement_List := 
	       Asis_S.Arm_Statements 
		  (The_Arm, Reference_Scan.Include_If_Statement_Pragmas);
	begin

	    if Trace.On then
		Trace.Log (The_Arm, The_Context);
		Trace.Add_Level (1 + Statements'Length);
	    end if;

	    Reference_Scan.Scan_Expression 
	       (Condition, Ctx.Set 
			      (The_Context, 
			       Basic_Context => Rvs.A_Read, 
			       Weight => 5, 
			       Add_Data_Access_Context => Rvs.An_If_Condition));

	    Reference_Scan.Scan_Statement_List (Statements, The_Context);

	end;

    exception

	when Asis.Asis_Inappropriate_Element =>
	    Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Arm);
	    raise Traversal_Error;

	when Asis.Asis_Failed =>
	    Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Arm);
	    raise Traversal_Error;

	when Traversal_Error =>
	    Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Arm);
	    raise;

    end Scan_If_Arm;

--| +-------------------------------------------------------------------------+
--| | SCAN_IF_STATEMENT_ARM (exported)                                        |
--| +-------------------------------------------------------------------------+

begin

    case Asis_S.If_Statement_Arm_Kind (The_Arm) is
	when Asis_S.An_If_Arm =>
	    Scan_If_Arm (The_Arm, The_Context);
	when Asis_S.An_Elsif_Arm =>
	    Scan_Elsif_Arm (The_Arm, The_Context);
	when Asis_S.An_Else_Arm =>
	    Scan_Else_Arm (The_Arm, The_Context);
	when Asis_S.Not_An_If_Statement_Arm =>
	    Error.Log (Error.An_Unhandled_Case, Cuid, Puid, The_Arm);
	    if Reference_Scan.Raise_Exception_On_Unhandled_Case then
		raise Traversal_Error;
	    else
		if Trace.On then
		    Trace.Log (The_Arm, The_Context);
		end if;
	    end if;
    end case;

end Scan_If_Statement_Arm;
