--| +=========================================================================+
--| |                                                                         |
--| | REGION_SCAN.REGION_SCAN_INTERNAL.SCAN_ANY (body)                        |
--| |                                                                         |
--| | Scans any kind of element.                                              |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Region_Scan.Region_Scan_Internal)
procedure Scan_Any (The_Element : in Asis.Element; 
		    The_Context : in out Context) is

    Cuid : constant String := "Region_Scan.Region_Scan_Internal.Scan_Any";
    Puid : constant String := "Scan_Any";

    package Error renames Region_Scan_Internal.Error_Handling_Support;

begin

    case Asis_E.Element_Kind (The_Element) is
	when Asis_E.A_Pragma =>
	    Region_Scan_Internal.Scan_Pragma (The_Element, The_Context);
	when Asis_E.An_Argument_Association =>
	    Region_Scan_Internal.Scan_Argument_Association 
	       (The_Element, The_Context);
	when Asis_E.A_Declaration =>
	    Region_Scan_Internal.Scan_Declaration (The_Element, The_Context);
	when Asis_E.An_Entity_Name_Definition =>
	    Region_Scan_Internal.Scan_Entity_Name_Definition 
	       (The_Element, The_Context);
	when Asis_E.A_Type_Definition =>
	    Region_Scan_Internal.Scan_Type_Definition 
	       (The_Element, The_Context);
	when Asis_E.A_Subtype_Indication =>
	    Region_Scan_Internal.Scan_Subtype_Indication 
	       (The_Element, The_Context);
	when Asis_E.A_Constraint =>
	    Region_Scan_Internal.Scan_Constraint (The_Element, The_Context);
	when Asis_E.A_Discrete_Range =>
	    Region_Scan_Internal.Scan_Discrete_Range (The_Element, The_Context);
	when Asis_E.A_Discriminant_Association =>
	    Region_Scan_Internal.Scan_Discriminant_Association 
	       (The_Element, The_Context);
	when Asis_E.A_Variant_Part =>
	    Region_Scan_Internal.Scan_Variant_Part (The_Element, The_Context);
	when Asis_E.A_Null_Component =>
	    Region_Scan_Internal.Scan_Null_Component (The_Element, The_Context);
	when Asis_E.A_Variant =>
	    Region_Scan_Internal.Scan_Variant (The_Element, The_Context);
	when Asis_E.A_Choice =>
	    Region_Scan_Internal.Scan_Choice (The_Element, The_Context);
	when Asis_E.A_Component_Association =>
	    Region_Scan_Internal.Scan_Component_Association 
	       (The_Element, The_Context);
	when Asis_E.An_Expression =>
	    Region_Scan_Internal.Scan_Expression (The_Element, The_Context);
	when Asis_E.A_Statement =>
	    Region_Scan_Internal.Scan_Statement (The_Element, The_Context);
	when Asis_E.An_If_Statement_Arm =>
	    Region_Scan_Internal.Scan_If_Statement_Arm 
	       (The_Element, The_Context);
	when Asis_E.A_Case_Statement_Alternative =>
	    Region_Scan_Internal.Scan_Case_Statement_Alternative 
	       (The_Element, The_Context);
	when Asis_E.A_Parameter_Association =>
	    Region_Scan_Internal.Scan_Parameter_Association 
	       (The_Element, The_Context);
	when Asis_E.A_Use_Clause =>
	    Region_Scan_Internal.Scan_Use_Clause (The_Element, The_Context);
	when Asis_E.A_Select_Statement_Arm =>
	    Region_Scan_Internal.Scan_Select_Statement_Arm 
	       (The_Element, The_Context);
	when Asis_E.A_Select_Alternative =>
	    Region_Scan_Internal.Scan_Select_Alternative 
	       (The_Element, The_Context);
	when Asis_E.A_With_Clause =>
	    Region_Scan_Internal.Scan_With_Clause (The_Element, The_Context);
	when Asis_E.An_Exception_Handler =>
	    Region_Scan_Internal.Scan_Exception_Handler 
	       (The_Element, The_Context);
	when Asis_E.A_Representation_Clause =>
	    Region_Scan_Internal.Scan_Representation_Clause 
	       (The_Element, The_Context);
	when Asis_E.A_Component_Clause =>
	    Region_Scan_Internal.Scan_Component_Clause 
	       (The_Element, The_Context);
	when Asis_E.Not_An_Element =>
	    Error.Log (Error.An_Unhandled_Case, Cuid, Puid, The_Element);
	    if Region_Scan_Internal.Raise_Exception_On_Unhandled_Case then
		raise Traversal_Error;
	    end if;
    end case;

end Scan_Any;
