--| +=========================================================================+
--| |                                                                         |
--| | REGION_SCAN.REGION_SCAN_INTERNAL.SCAN_COMPONENT_CLAUSE (body)           |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Region_Scan.Region_Scan_Internal)
procedure Scan_Component_Clause (The_Clause : in Asis.Component_Clause; 
				 The_Context : in out Context) is

    Cuid : constant String := 
       "Region_Scan.Region_Scan_Internal.Scan_Component_Clause";
    Puid : constant String := "Scan_Component_Clause";

    package Error renames Region_Scan_Internal.Error_Handling_Support;

begin

    if Rgn.Denotes_One_Or_More_Regions (The_Clause, 
					Region_Scan.Expand_Instantiations) then
	declare
	    Remaining_Parent_Elements : constant Asis.Element_List := 
	       Rgn.Non_Region_Subelements (The_Clause, 
					   Region_Scan.Expand_Instantiations);
	    Regions : constant Rgn.Region_List := 
	       Rgn.Denoted_Regions (The_Clause, 
				    Region_Scan.Expand_Instantiations, 
				    Region_Scan.Include_Instance_Bodies);
	begin
	    Region_Scan_Internal.Scan_Any_List 
	       (Remaining_Parent_Elements, The_Context);
	    for I in Regions'Range loop
		Region_Scan.Process_Region (Regions (I), The_Context);
	    end loop;
	end;
	return;
    end if;

    declare
	Address : Asis.Expression := 
	   Asis_Rc.Component_Clause_Relative_Address (The_Clause);
	Name : Asis.Simple_Name := Asis_Rc.Component_Clause_Name (The_Clause);
	The_Range : Asis.Range_Constraint := 
	   Asis_Rc.Component_Clause_Range (The_Clause);
    begin

	Region_Scan_Internal.Scan_Expression (Name, The_Context);

	Region_Scan_Internal.Scan_Expression (Address, The_Context);

	Region_Scan_Internal.Scan_Discrete_Range (The_Range, The_Context);

    end;

exception

    when Asis.Asis_Inappropriate_Element =>
	Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Clause);
	raise Traversal_Error;

    when Asis.Asis_Failed =>
	Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Clause);
	raise Traversal_Error;

    when Traversal_Error =>
	Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Clause);
	raise;

end Scan_Component_Clause;
