--| +=========================================================================+
--| |                                                                         |
--| | REGION_SCAN.REGION_SCAN_INTERNAL.SCAN_CONTEXT_CLAUSE_LIST (body)        |
--| |                                                                         |
--| | Scans a list of with clauses, use clauses, and pragmas located in       |
--| | the context clause of a compilation unit.                               |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Region_Scan.Region_Scan_Internal)
procedure Scan_Context_Clause_List (The_List : in Asis.Context_Clause_List; 
				    The_Context : in out Context) is

    Cuid : constant String := 
       "Region_Scan.Region_Scan_Internal.Scan_Context_Clause_List";
    Puid : constant String := "Scan_Context_Clause_List";

    package Error renames Region_Scan_Internal.Error_Handling_Support;

    The_Element : Asis.Element;

begin

    for I in The_List'Range loop
	The_Element := The_List (I);
	case Asis_E.Element_Kind (The_Element) is
	    when Asis_E.A_With_Clause =>
		Region_Scan_Internal.Scan_With_Clause 
		   (The_Element, The_Context);
	    when Asis_E.A_Use_Clause =>
		Region_Scan_Internal.Scan_Use_Clause (The_Element, The_Context);
	    when Asis_E.A_Pragma =>
		Region_Scan_Internal.Scan_Pragma (The_Element, The_Context);
	    when others =>
		Error.Log (Error.An_Unhandled_Case, Cuid, Puid, The_Element);
		if Region_Scan_Internal.Raise_Exception_On_Unhandled_Case then
		    raise Traversal_Error;
		end if;
	end case;
    end loop;

end Scan_Context_Clause_List;
